/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Scrollable;

class ImagePanel
extends JPanel
implements Scrollable {
    private BufferedImage image;
    private double zoom = 1.0;
    private int oldWidth;
    private int oldHeight;

    public ImagePanel(BufferedImage image) {
        this.image = image;
        this.oldWidth = image.getWidth();
        this.oldHeight = image.getHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.DARK_GRAY);
        g.clearRect(0, 0, this.oldWidth, this.oldHeight);
        g.drawImage(this.image, 0, 0, this.getZoomWidth(), this.getZoomHeight(), null);
    }

    private int getZoomHeight() {
        return (int)((double)this.image.getHeight() * this.zoom);
    }

    private int getZoomWidth() {
        return (int)((double)this.image.getWidth() * this.zoom);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getZoomWidth(), this.getZoomHeight());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getZoomWidth(), this.getZoomHeight());
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return (int)(40.0 * this.zoom);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height - 40;
        }
        return visibleRect.width - 40;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void increaseZoom() {
        if (this.zoom < 8.0) {
            this.zoom *= 2.0;
            this.revalidate();
        }
    }

    public void decreaseZoom() {
        if (this.zoom > 0.13) {
            this.oldWidth = this.getZoomWidth();
            this.oldHeight = this.getZoomHeight();
            this.zoom /= 2.0;
            this.revalidate();
        }
    }

    public void setImage(BufferedImage image) {
        this.oldWidth = this.getZoomWidth();
        this.oldHeight = this.getZoomHeight();
        this.image = image;
        this.revalidate();
        this.repaint();
    }
}

