/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.CompareResult;
import de.redsix.pdfcompare.ImagePanel;
import de.redsix.pdfcompare.ViewModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Display {
    public Display(CompareResult compareResult) {
        ViewModel viewModel = new ViewModel(compareResult);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        BorderLayout borderLayout = new BorderLayout();
        frame.setLayout(borderLayout);
        frame.setMinimumSize(new Dimension(400, 200));
        Rectangle screenBounds = Display.getDefaultScreenBounds();
        frame.setSize(Math.min(screenBounds.width, 1700), Math.min(screenBounds.height, 1000));
        frame.setLocation(screenBounds.x, screenBounds.y);
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        frame.add((Component)toolBar, "First");
        ImagePanel leftPanel = new ImagePanel(viewModel.getLeftImage());
        ImagePanel resultPanel = new ImagePanel(viewModel.getDiffImage());
        JScrollPane expectedScrollPane = new JScrollPane(leftPanel);
        expectedScrollPane.setMinimumSize(new Dimension(200, 200));
        JScrollPane actualScrollPane = new JScrollPane(resultPanel);
        actualScrollPane.setMinimumSize(new Dimension(200, 200));
        expectedScrollPane.getVerticalScrollBar().setModel(actualScrollPane.getVerticalScrollBar().getModel());
        expectedScrollPane.getHorizontalScrollBar().setModel(actualScrollPane.getHorizontalScrollBar().getModel());
        JSplitPane splitPane = new JSplitPane(1, expectedScrollPane, actualScrollPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        splitPane.setOneTouchExpandable(true);
        frame.add((Component)splitPane, "Center");
        Display.addToolBarButton(toolBar, "Page -", event -> {
            if (viewModel.decreasePage()) {
                leftPanel.setImage(viewModel.getLeftImage());
                resultPanel.setImage(viewModel.getDiffImage());
            }
        });
        Display.addToolBarButton(toolBar, "Page +", event -> {
            if (viewModel.increasePage()) {
                leftPanel.setImage(viewModel.getLeftImage());
                resultPanel.setImage(viewModel.getDiffImage());
            }
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Zoom -", event -> {
            leftPanel.decreaseZoom();
            resultPanel.decreaseZoom();
        });
        Display.addToolBarButton(toolBar, "Zoom +", event -> {
            leftPanel.increaseZoom();
            resultPanel.increaseZoom();
        });
        toolBar.addSeparator();
        Display.addToolBarButton(toolBar, "Center Split", event -> {
            splitPane.setDividerLocation(0.5);
            splitPane.revalidate();
        });
        toolBar.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton expectedButton = new JToggleButton("Expected");
        expectedButton.doClick();
        expectedButton.addActionListener(event -> {
            viewModel.showExpected();
            leftPanel.setImage(viewModel.getLeftImage());
        });
        toolBar.add(expectedButton);
        buttonGroup.add(expectedButton);
        JToggleButton actualButton = new JToggleButton("Actual");
        actualButton.addActionListener(event -> {
            viewModel.showActual();
            leftPanel.setImage(viewModel.getLeftImage());
        });
        toolBar.add(actualButton);
        buttonGroup.add(actualButton);
        frame.setVisible(true);
    }

    private static void addToolBarButton(JToolBar toolBar, String label, ActionListener actionListener) {
        JButton button = new JButton(label);
        button.addActionListener(actionListener);
        toolBar.add(button);
    }

    private static Rectangle getDefaultScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }
}

