/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class CompareResult {
    private Map<Integer, BufferedImage> diffImages = new TreeMap<Integer, BufferedImage>();
    private Map<Integer, BufferedImage> expectedImages = new TreeMap<Integer, BufferedImage>();
    private Map<Integer, BufferedImage> actualImages = new TreeMap<Integer, BufferedImage>();
    private boolean isEqual = true;

    public boolean writeTo(String filename) {
        if (this.isEqual) {
            return this.isEqual;
        }
        try (PDDocument document = new PDDocument();){
            for (Map.Entry<Integer, BufferedImage> entry : this.diffImages.entrySet()) {
                BufferedImage image = entry.getValue();
                PDPage page = new PDPage(new PDRectangle((float)image.getWidth(), (float)image.getHeight()));
                document.addPage(page);
                String tmpFilename = filename + "_page_" + (entry.getKey() + 1) + ".png";
                File tmpFile = new File(tmpFilename);
                PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)document, (BufferedImage)image);
                try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                    contentStream.drawImage(imageXObject, 0.0f, 0.0f);
                }
                tmpFile.delete();
            }
            document.save(filename + ".pdf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.isEqual;
    }

    public void addPageThatsEqual(int pageIndex, BufferedImage diffImage) {
        this.expectedImages.put(pageIndex, diffImage);
        this.actualImages.put(pageIndex, diffImage);
        this.diffImages.put(pageIndex, diffImage);
    }

    public void addPageThatsNotEqual(int pageIndex, BufferedImage diffImage) {
        this.isEqual = false;
        this.diffImages.put(pageIndex, diffImage);
    }

    public void addPageThatsNotEqual(int pageIndex, BufferedImage expectedImage, BufferedImage actualImage, BufferedImage diffImage) {
        this.isEqual = false;
        this.expectedImages.put(pageIndex, expectedImage);
        this.actualImages.put(pageIndex, actualImage);
        this.diffImages.put(pageIndex, diffImage);
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public boolean isNotEqual() {
        return !this.isEqual;
    }

    public BufferedImage getDiffImage(int page) {
        return this.diffImages.get(page);
    }

    public BufferedImage getExpectedImage(int page) {
        return this.expectedImages.get(page);
    }

    public BufferedImage getActualImage(int page) {
        return this.actualImages.get(page);
    }

    public int getNumberOfPages() {
        return Collections.max(this.diffImages.keySet());
    }
}

