/*
 * Decompiled with CFR 0.152.
 */
package de.qualersoft.jmeter.gradleplugin.task;

import de.qualersoft.jmeter.gradleplugin.CopyResource;
import de.qualersoft.jmeter.gradleplugin.CopyResourceKt;
import de.qualersoft.jmeter.gradleplugin.JMeterConfig;
import de.qualersoft.jmeter.gradleplugin.JMeterPluginKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@CacheableTask
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002J\b\u0010$\u001a\u00020!H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\r8\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006%"}, d2={"Lde/qualersoft/jmeter/gradleplugin/task/JMeterSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "jmBinDir", "Ljava/io/File;", "jmExtDir", "jmJUnitDir", "jmJar", "Lorg/gradle/api/file/RegularFileProperty;", "getJmJar$jmeter_gradle_plugin", "()Lorg/gradle/api/file/RegularFileProperty;", "jmLibDir", "jmTool", "Lde/qualersoft/jmeter/gradleplugin/JMeterConfig;", "getJmTool", "()Lde/qualersoft/jmeter/gradleplugin/JMeterConfig;", "jmToolDir", "getJmToolDir", "()Ljava/io/File;", "sourceJmJar", "getSourceJmJar", "sourceJmJar$delegate", "Lkotlin/Lazy;", "findArtifactMatch", "artifacts", "", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "group", "", "name", "getJMeterLib", "getJMeterResourceLib", "prepareDirectories", "", "resolveAndCopyExtensionLibs", "resolveAndCopyToolLibs", "run", "jmeter-gradle-plugin"})
public class JMeterSetupTask
extends DefaultTask {
    @Nested
    @NotNull
    private final JMeterConfig jmTool;
    @OutputDirectory
    @NotNull
    private final File jmToolDir;
    @NotNull
    private final File jmBinDir;
    @NotNull
    private final File jmLibDir;
    @NotNull
    private final File jmExtDir;
    @NotNull
    private final File jmJUnitDir;
    @NotNull
    private final Lazy sourceJmJar$delegate;
    @NotNull
    private final RegularFileProperty jmJar;

    public JMeterSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.jmTool = JMeterPluginKt.jmeter(project).getTool();
        File file = this.getProject().getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        this.jmToolDir = FilesKt.resolve((File)file, (String)"jmeter");
        this.jmBinDir = FilesKt.resolve((File)this.jmToolDir, (String)"bin");
        this.jmLibDir = FilesKt.resolve((File)this.jmToolDir, (String)"lib");
        this.jmExtDir = FilesKt.resolve((File)this.jmLibDir, (String)"ext");
        this.jmJUnitDir = FilesKt.resolve((File)this.jmLibDir, (String)"junit");
        this.sourceJmJar$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ JMeterSetupTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return JMeterSetupTask.access$getJMeterLib(this.this$0);
            }
        }));
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty().value(() -> JMeterSetupTask.jmJar$lambda-0(this));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProp\u2026jmTool.version}.jar\")\n  }");
        this.jmJar = regularFileProperty;
        this.setGroup("jmeter");
    }

    @NotNull
    protected final JMeterConfig getJmTool() {
        return this.jmTool;
    }

    @NotNull
    protected final File getJmToolDir() {
        return this.jmToolDir;
    }

    private final File getSourceJmJar() {
        Lazy lazy = this.sourceJmJar$delegate;
        return (File)lazy.getValue();
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getJmJar$jmeter_gradle_plugin() {
        return this.jmJar;
    }

    @TaskAction
    public final void run() {
        this.prepareDirectories();
        File file = this.getSourceJmJar();
        Object object = this.jmJar.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jmJar.asFile.get()");
        FilesKt.copyTo$default((File)file, (File)((File)object), (boolean)true, (int)0, (int)4, null);
        File resourceJar = this.getJMeterResourceLib();
        CopyResource.INSTANCE.extractJarToDir(new JarFile(resourceJar), this.jmToolDir);
        this.resolveAndCopyExtensionLibs();
        this.resolveAndCopyToolLibs();
    }

    private final File getJMeterLib() {
        Set set = this.getProject().getConfigurations().getByName("jmeterRunner").getResolvedConfiguration().getResolvedArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.configurations\n \u2026\n      .resolvedArtifacts");
        Set artifacts = set;
        return this.findArtifactMatch(artifacts, this.jmTool.getGroup(), this.jmTool.getName());
    }

    private final File getJMeterResourceLib() {
        Set set = this.getProject().getConfigurations().getByName("jmeterRunner").getResolvedConfiguration().getResolvedArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.configurations\n \u2026\n      .resolvedArtifacts");
        Set artifacts = set;
        Map<String, String> toolConfNot = this.jmTool.createToolConfigDependencyNotion();
        String string = toolConfNot.get("name");
        Intrinsics.checkNotNull((Object)string);
        String toolConfName = string;
        return this.findArtifactMatch(artifacts, this.jmTool.getGroup(), toolConfName);
    }

    private final File findArtifactMatch(Set<? extends ResolvedArtifact> artifacts, String group, String name) {
        Object v0;
        Object object;
        Iterable iterable;
        block2: {
            iterable = artifacts;
            object = iterable;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                ResolvedArtifact it = (ResolvedArtifact)t;
                boolean bl = false;
                ModuleVersionIdentifier id = it.getModuleVersion().getId();
                if (!(Intrinsics.areEqual((Object)id.getGroup(), (Object)group) && Intrinsics.areEqual((Object)id.getName(), (Object)name))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Iterable iterable2 = iterable = v0;
        if (iterable2 == null) {
            object = "Required value was null.";
            throw (Throwable)new IllegalStateException(object.toString());
        }
        File file = ((ResolvedArtifact)iterable2).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"checkNotNull(\n    artifa\u2026me == name\n    }\n  ).file");
        return file;
    }

    private final void resolveAndCopyExtensionLibs() {
        Iterable $this$filterNotTo$iv$iv;
        Collection collection;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        ResolvedDependency it;
        Iterable $this$flatMapTo$iv$iv;
        List resolvedExtensions = new ArrayList();
        Set set = this.getProject().getConfigurations().getByName("jmeterPlugin").getResolvedConfiguration().getFirstLevelModuleDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.configurations.g\u2026stLevelModuleDependencies");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            resolvedExtensions.add(it);
            Set set2 = it.getModuleArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.moduleArtifacts");
            list$iv$iv = set2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            list$iv$iv = (ResolvedArtifact)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it2 = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            CopyResourceKt.copyToDir(it2, this.jmExtDir);
        }
        $this$flatMap$iv = resolvedExtensions;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            Set set3 = it.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"it.children");
            list$iv$iv = set3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            if (resolvedExtensions.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ResolvedDependency)element$iv$iv;
            boolean bl = false;
            Set set4 = it.getAllModuleArtifacts();
            Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"it.allModuleArtifacts");
            list$iv$iv = set4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator bl = $this$mapTo$iv$iv.iterator();
        while (bl.hasNext()) {
            item$iv$iv = bl.next();
            list$iv$iv = (ResolvedArtifact)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getFile());
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it3 = (File)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            CopyResourceKt.copyToDir(it3, this.jmLibDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveAndCopyToolLibs() {
        void $this$mapTo$iv$iv;
        Set set = this.getProject().getConfigurations().getByName("jmeterLibrary").getResolvedConfiguration().getResolvedArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.configurations.g\u2026\n      .resolvedArtifacts");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            CopyResourceKt.copyToDir(it, this.jmLibDir);
        }
    }

    private final void prepareDirectories() {
        if (!this.jmToolDir.exists()) {
            this.jmToolDir.mkdirs();
        }
        if (!this.jmBinDir.exists()) {
            this.jmBinDir.mkdirs();
        }
        if (!this.jmLibDir.exists()) {
            this.jmLibDir.mkdirs();
        }
        if (!this.jmExtDir.exists()) {
            this.jmExtDir.mkdirs();
        }
        if (!this.jmJUnitDir.exists()) {
            this.jmJUnitDir.mkdirs();
        }
    }

    private static final File jmJar$lambda-0(JMeterSetupTask this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return FilesKt.resolve((File)this$0.jmBinDir, (String)(this$0.jmTool.getName() + '-' + this$0.jmTool.getVersion() + ".jar"));
    }

    public static final /* synthetic */ File access$getJMeterLib(JMeterSetupTask $this) {
        return $this.getJMeterLib();
    }
}

