/*
 * Decompiled with CFR 0.152.
 */
package de.qualersoft.jmeter.gradleplugin;

import de.qualersoft.jmeter.gradleplugin.JMeterConfig;
import de.qualersoft.jmeter.gradleplugin.JMeterExtension;
import de.qualersoft.jmeter.gradleplugin.task.JMeterSetupTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.language.base.internal.plugins.CleanRule;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a8\u0006\u000e"}, d2={"Lde/qualersoft/jmeter/gradleplugin/JMeterPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "applyResolutionStrategyFor", "config", "Lorg/gradle/api/artifacts/Configuration;", "registerClean", "Lorg/gradle/api/internal/project/ProjectInternal;", "registerConfiguration", "registerToolSetup", "jmeter-gradle-plugin"})
public final class JMeterPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{project};
        JMeterExtension jmExt = (JMeterExtension)project.getExtensions().create("jmeter", JMeterExtension.class, objectArray);
        this.registerConfiguration(project);
        this.registerToolSetup(project);
        project.afterEvaluate(arg_0 -> JMeterPlugin.apply$lambda-0(this, project, jmExt, arg_0));
    }

    private final void registerConfiguration(Project project) {
        Configuration runnerConf = (Configuration)project.getConfigurations().maybeCreate("jmeterRunner");
        runnerConf.setVisible(false);
        runnerConf.setDescription("The jmeter runner to use. Only for internal purposes!");
        Intrinsics.checkNotNullExpressionValue((Object)runnerConf, (String)"runnerConf");
        this.applyResolutionStrategyFor(runnerConf, project);
        Configuration jmComp = (Configuration)project.getConfigurations().maybeCreate("jmeterPlugin");
        jmComp.setDescription("JMeter extensions like 3rd party plugins. See `jmCoreExt` for easy adding jmeter extensions.");
        jmComp.setVisible(true);
        jmComp.setCanBeConsumed(false);
        jmComp.setCanBeResolved(true);
        Intrinsics.checkNotNullExpressionValue((Object)jmComp, (String)"jmComp");
        this.applyResolutionStrategyFor(jmComp, project);
        Configuration tools = (Configuration)project.getConfigurations().maybeCreate("jmeterLibrary");
        tools.setDescription("Additional tool libraries that can be used within jmeter scripts. E.g. apache-commons");
        Intrinsics.checkNotNullExpressionValue((Object)tools, (String)"tools");
        this.applyResolutionStrategyFor(tools, project);
    }

    private final void applyResolutionStrategyFor(Configuration config, Project project) {
        config.attributes(arg_0 -> JMeterPlugin.applyResolutionStrategyFor$lambda-1(project, arg_0));
    }

    private final void registerClean(ProjectInternal project) {
        if (project.getTasks().findByName("clean") == null) {
            DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
            BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)project.getServices().get(BuildOutputCleanupRegistry.class);
            buildOutputCleanupRegistry.registerOutputs((Object)buildDir);
            TaskProvider clean = project.getTasks().register("clean", Delete.class, arg_0 -> JMeterPlugin.registerClean$lambda-2(buildDir, arg_0));
            buildOutputCleanupRegistry.registerOutputs((Object)clean.map(JMeterPlugin::registerClean$lambda-3));
            project.getTasks().addRule((Rule)new CleanRule((TaskContainer)project.getTasks()));
        }
    }

    private final void registerToolSetup(Project project) {
        project.getTasks().register("setupJMeter", JMeterSetupTask.class);
    }

    private static final void apply$lambda-0(JMeterPlugin this$0, Project $project, JMeterExtension $jmExt, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        this$0.registerClean((ProjectInternal)it);
        Configuration jmRunner = (Configuration)$project.getConfigurations().named("jmeterRunner").get();
        JMeterConfig jMeterConfig = $jmExt.getTool();
        Intrinsics.checkNotNullExpressionValue((Object)jmRunner, (String)"jmRunner");
        jMeterConfig.applyTo(jmRunner);
        Configuration jmComp = (Configuration)$project.getConfigurations().named("jmeterPlugin").get();
        JMeterConfig jMeterConfig2 = $jmExt.getTool();
        Intrinsics.checkNotNullExpressionValue((Object)jmComp, (String)"jmComp");
        jMeterConfig2.applyApacheComponents(jmComp);
    }

    private static final void applyResolutionStrategyFor$lambda-1(Project $project, AttributeContainer it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Category libCat = (Category)$project.getObjects().named(Category.class, "library");
        it.attribute(Category.CATEGORY_ATTRIBUTE, (Object)libCat);
        Bundling libBundling = (Bundling)$project.getObjects().named(Bundling.class, "external");
        it.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)libBundling);
    }

    private static final void registerClean$lambda-2(DirectoryProperty $buildDir, Delete it) {
        it.setDescription("Deletes the build directory (added by jmeter-task)");
        it.setGroup("build");
        Object[] objectArray = new Object[]{$buildDir};
        it.delete(objectArray);
    }

    private static final FileCollection registerClean$lambda-3(Delete it) {
        return it.getTargetFiles();
    }
}

