/*
 * Decompiled with CFR 0.152.
 */
package de.qualersoft.jmeter.gradleplugin;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%J\b\u0010*\u001a\u00020'H\u0002J\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060,J\u0014\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060,H\u0002J&\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060/2\u0006\u0010\u001a\u001a\u00020\u00062\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0006R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R1\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\b\"\u0004\b\u001c\u0010\nR\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\n\u00a8\u00060"}, d2={"Lde/qualersoft/jmeter/gradleplugin/JMeterConfig;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "group", "", "getGroup", "()Ljava/lang/String;", "setGroup", "(Ljava/lang/String;)V", "logger", "Lorg/gradle/api/logging/Logger;", "mainClass", "Lorg/gradle/api/provider/Property;", "getMainClass", "()Lorg/gradle/api/provider/Property;", "mainConfigureClosure", "Lkotlin/Function1;", "Lorg/gradle/api/artifacts/ExternalModuleDependency;", "", "Lkotlin/ExtensionFunctionType;", "getMainConfigureClosure", "()Lkotlin/jvm/functions/Function1;", "setMainConfigureClosure", "(Lkotlin/jvm/functions/Function1;)V", "name", "getName", "setName", "objects", "Lorg/gradle/api/model/ObjectFactory;", "kotlin.jvm.PlatformType", "version", "getVersion", "setVersion", "applyApacheComponents", "config", "Lorg/gradle/api/artifacts/Configuration;", "applyBomWorkaround", "Lorg/gradle/api/artifacts/Dependency;", "dependency", "applyTo", "createJMeterLibDependency", "createToolConfigDependencyNotion", "", "createToolDependencyNotation", "jmeterDependency", "", "jmeter-gradle-plugin"})
public final class JMeterConfig {
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    private final ObjectFactory objects;
    @Input
    @NotNull
    private String group;
    @Input
    @NotNull
    private String name;
    @Input
    @NotNull
    private String version;
    @Internal
    @Nullable
    private Function1<? super ExternalModuleDependency, Unit> mainConfigureClosure;
    @Input
    @NotNull
    private final Property<String> mainClass;

    public JMeterConfig(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logging.getLogger(JMeterConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(JMeterConfig::class.java)");
        this.logger = logger;
        this.objects = this.project.getObjects();
        this.group = "org.apache.jmeter";
        this.name = "ApacheJMeter";
        this.version = "5.4.1";
        Property property = this.objects.property(String.class).convention((Object)"org.apache.jmeter.NewDriver");
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"objects.property(String:\u2026apache.jmeter.NewDriver\")");
        this.mainClass = property;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    public final void setGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.group = string;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version = string;
    }

    @Nullable
    public final Function1<ExternalModuleDependency, Unit> getMainConfigureClosure() {
        return this.mainConfigureClosure;
    }

    public final void setMainConfigureClosure(@Nullable Function1<? super ExternalModuleDependency, Unit> function1) {
        this.mainConfigureClosure = function1;
    }

    @NotNull
    public final Property<String> getMainClass() {
        return this.mainClass;
    }

    public final void applyTo(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        config.getDependencies().add((Object)this.createJMeterLibDependency());
        Map<String, String> toolConfigDepNot = this.createToolConfigDependencyNotion();
        Dependency toolConfigDep = this.project.getDependencies().create(toolConfigDepNot);
        DependencySet dependencySet = config.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)toolConfigDep, (String)"toolConfigDep");
        dependencySet.add((Object)this.applyBomWorkaround(toolConfigDep));
    }

    public final void applyApacheComponents(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object[] objectArray = new String[]{"bolt", "components", "core", "ftp", "functions", "http", "java", "jdbc", "jms", "junit", "ldap", "mail", "mongodb", "native", "tcp"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Map depNot = JMeterConfig.jmeterDependency$default(this, it, null, 2, null);
            Dependency dep = this.project.getDependencies().create((Object)depNot);
            this.logger.debug("Adding dependency for {}", (Object)dep);
            DependencySet dependencySet = config.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dep, (String)"dep");
            dependencySet.add((Object)this.applyBomWorkaround(dep));
        }
    }

    private final Dependency createJMeterLibDependency() {
        Map<String, String> depNot = this.createToolDependencyNotation();
        Dependency result = this.project.getDependencies().create(depNot);
        Function1<? super ExternalModuleDependency, Unit> function1 = this.mainConfigureClosure;
        if (function1 != null) {
            Function1<? super ExternalModuleDependency, Unit> function12;
            Function1<? super ExternalModuleDependency, Unit> it = function12 = function1;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.ExternalModuleDependency");
            it.invoke((Object)((ExternalModuleDependency)result));
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return this.applyBomWorkaround(result);
    }

    @NotNull
    public final Dependency applyBomWorkaround(@NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        if (dependency instanceof ExternalModuleDependency) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)this.group), TuplesKt.to((Object)"module", (Object)"bom")};
            ((ExternalModuleDependency)dependency).exclude(MapsKt.mapOf((Pair[])pairArray));
        }
        return dependency;
    }

    private final Map<String, String> createToolDependencyNotation() {
        Map map;
        Map res = map = (Map)new LinkedHashMap();
        boolean bl = false;
        res.put("group", this.group);
        res.put("name", this.name);
        res.put("version", this.version);
        return map;
    }

    @NotNull
    public final Map<String, String> createToolConfigDependencyNotion() {
        return JMeterConfig.jmeterDependency$default(this, "config", null, 2, null);
    }

    @NotNull
    public final Map<String, String> jmeterDependency(@NotNull String name, @Nullable String version) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map it = map = (Map)new LinkedHashMap();
        boolean bl = false;
        it.put("group", this.group);
        it.put("name", "ApacheJMeter_" + name);
        String string = version;
        if (string == null) {
            string = this.version;
        }
        it.put("version", string);
        return map;
    }

    public static /* synthetic */ Map jmeterDependency$default(JMeterConfig jMeterConfig, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return jMeterConfig.jmeterDependency(string, string2);
    }
}

