/*
 * Decompiled with CFR 0.152.
 */
package de.qualersoft.jmeter.gradleplugin;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/qualersoft/jmeter/gradleplugin/CopyResource;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "copyStream", "", "srcStream", "Ljava/io/InputStream;", "destStream", "Ljava/io/OutputStream;", "extractJarToDir", "jarFile", "Ljava/util/jar/JarFile;", "targetDir", "Ljava/io/File;", "jmeter-gradle-plugin"})
public final class CopyResource {
    @NotNull
    public static final CopyResource INSTANCE = new CopyResource();
    @NotNull
    private static final Logger log;

    private CopyResource() {
    }

    public final void extractJarToDir(@NotNull JarFile jarFile, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
        Enumeration<JarEntry> enumeration2 = enumeration;
        ArrayList<JarEntry> arrayList = Collections.list(enumeration2);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry it = (JarEntry)element$iv;
            boolean bl = false;
            String filename = it.getName();
            log.trace("Going to copy: {}", (Object)filename);
            File destFile = new File(targetDir, filename);
            if (it.isDirectory()) {
                log.trace("{} is directory -> creating it", (Object)filename);
                destFile.mkdirs();
                continue;
            }
            InputStream inputStream = jarFile.getInputStream(it);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jarFile.getInputStream(it)");
            INSTANCE.copyStream(inputStream, new FileOutputStream(destFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyStream(@NotNull InputStream srcStream, @NotNull OutputStream destStream) {
        Intrinsics.checkNotNullParameter((Object)srcStream, (String)"srcStream");
        Intrinsics.checkNotNullParameter((Object)destStream, (String)"destStream");
        Closeable closeable = srcStream;
        Throwable throwable = null;
        try {
            long l;
            InputStream src = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = destStream;
            Throwable throwable2 = null;
            try {
                OutputStream dest = (OutputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)src, (OutputStream)dest, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Logger logger = Logging.getLogger(CopyResource.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(CopyResource::class.java)");
        log = logger;
    }
}

