package de.pco.example;

/*-
 * #%L
 * pco-example
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import java.awt.Component;

import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JSpinner.NumberEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

import de.pco.common.enums.MetadataField;

/**
 * Required class of the JTable API that represents the UI components used for
 * editing the values in the table 
 * @author PCO
 *
 */
public class MetadataTableEditor extends AbstractCellEditor implements TableCellEditor
{
    private JTextField textTF = null;
    private JCheckBox checkboxCB = null;
    private JSpinner spinnerS = null;
    private JComboBox comboboxCB = null;
    
    private int requestedRow = -1;
    
    /**
     * Constructor
     */
    public MetadataTableEditor() 
    {
        this.textTF = new JTextField();
        this.textTF.setDocument(new PlainDocument()
        {
            public void insertString( int offset, String  str, AttributeSet attr ) throws BadLocationException 
            {
                final int LIMIT = 40;
                if (str == null) return;
        
                if ((getLength() + str.length()) <= LIMIT) {
                    super.insertString(offset, str, attr);
                }
            }
        });
        this.checkboxCB = new JCheckBox();
        this.comboboxCB = new JComboBox();
        this.spinnerS = new JSpinner();
    }

    /**
     * Returns the value of the edited cell
     */
    @Override
    public Object getCellEditorValue() 
    {
        MetadataField enumValue = MetadataField.values()[this.requestedRow];
        if (MetadataField.isBooleanField(enumValue) == true) {
            return this.checkboxCB.isSelected();
        }
        else if (MetadataField.isEnumField(enumValue) == true) {
            return this.comboboxCB.getSelectedItem();
        }
        else if (MetadataField.isTextField(enumValue) == true) {
            return this.textTF.getText();
        }
        else {
            return this.spinnerS.getValue();
        }
    }

    /**
     * Returns the UI component in which the cell should be edited. 
     */
    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) 
    {
        MetadataField enumValue = MetadataField.values()[row];
        this.requestedRow = row;
        
        if (MetadataField.isBooleanField(enumValue) == true) 
        {
            this.checkboxCB.setSelected((boolean)value);
            return this.checkboxCB;
        }
        else if (MetadataField.isEnumField(enumValue) == true) 
        {
            while(this.comboboxCB.getItemCount() != 0) {
                this.comboboxCB.removeItemAt(0);
            }
            int count = 0;
            for(Object object : MetadataField.getEnumFieldValues(enumValue)) 
            {
                this.comboboxCB.insertItemAt(object, this.comboboxCB.getItemCount());
                if (object.equals(value) == true) {                    
                    this.comboboxCB.setSelectedIndex(count);
                }
                count++;
            }
            return this.comboboxCB;
        }
        else if (MetadataField.isTextField(enumValue) == true) 
        {
            this.textTF.setText(value.toString());
            return this.textTF;
        }
        else // it is number 
        { 
            Comparable min = MetadataField.getMinValue(enumValue);
            Comparable max = MetadataField.getMaxValue(enumValue);
            Object step = MetadataField.getStepValue(enumValue);
            SpinnerNumberModel snm = null;
            NumberEditor editor = null;
            if (value instanceof Double) 
            {
                snm = new SpinnerNumberModel((double)value,
                    (double)min, (double)max,
                    (double)step);
                this.spinnerS = new JSpinner(snm);
                editor = new JSpinner.NumberEditor(this.spinnerS, "0.0########");
            }
            else {
                snm = new SpinnerNumberModel(Integer.parseInt(value.toString()),Integer.parseInt(min.toString()),
                    Integer.parseInt(max.toString()), Integer.parseInt(step.toString()));
                this.spinnerS = new JSpinner(snm);
                editor = new JSpinner.NumberEditor(this.spinnerS, "#");
            }
            JFormattedTextField textField = editor.getTextField();
            textField.setHorizontalAlignment(JTextField.LEFT);
            this.spinnerS.setEditor(editor);
//            snm.setValue(value);
//            snm.setMaximum(max);
//            snm.setMinimum(min);
//            snm.setStepSize((Number)step);
                    //(SpinnerNumberModel)this.spinnerS.getModel();
            
            return this.spinnerS;
        }
    }
}
