/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common.enums;

public enum CameraType {
    UNDEFINED(0),
    PCO1200HS(256),
    PCO1300(512),
    PCO1600(544),
    PCO2000(576),
    PCO4000(608),
    ROCHEHTC(2048),
    XS284(2048),
    KODAK1300OEM(2080),
    PCO1400(2096),
    NEWGEN(2112),
    PROVEHR(2128),
    PCO_USBPIXELFLY(2304),
    PCO_DIMAX_STD(4096),
    PCO_DIMAX_TV(4112),
    PCO_DIMAX_AUTOMOTIVE(4128),
    PCO_DIMAX_CS(4128),
    SC3_SONYQUE(4608),
    SC3_EMTI(4624),
    SC3_KODAK4800(4640),
    PCO_EDGE(4864),
    PCO_EDGE_42(4866),
    PCO_EDGE_GL(4880),
    PCO_EDGE_USB3(4896),
    PCO_EDGE_HS(4928),
    PCO_EDGE_MT(4868),
    PCO_FLIM(5120),
    PCO_FLOW(5376),
    PCO_PANDA(5632),
    PCO_FAMILY_PANDA(5632),
    PCO_FAMILY_EDGE(6144),
    PCO_FAMILY_DICAM(5888),
    PCO_FAMILY_DIMAX(6400),
    PCOUPDATE(65535);

    private int value;

    private CameraType(int value) {
        this.value = value;
    }

    public static CameraType valueOf(int value) throws IllegalArgumentException {
        for (CameraType e : CameraType.values()) {
            if (e.value != value) continue;
            return e;
        }
        throw new IllegalArgumentException("incorrect camera type constant number");
    }

    public boolean isCameraFamilyName() {
        return this.name().startsWith("PCO_FAMILY");
    }

    public int getValue() {
        return this.value;
    }
}

