/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common.enums;

import de.pco.common.enums.CameraType;

public enum CameraSubtype {
    UNDEFINED(0),
    PCO_DIMAX_Weisscam(100),
    PCO_DIMAX_HD(33023),
    PCO_DIMAX_HD_PLUS(49407),
    PCO_DIMAX_X35(200),
    PCO_DIMAX_HS1(8319),
    PCO_DIMAX_HS2(8575),
    PCO_DIMAX_HS4(9087),
    PCO_DIMAX_CS_AM_DEPRECATED(16511),
    PCO_DIMAX_CS_1(16767),
    PCO_DIMAX_CS_2(17023),
    PCO_DIMAX_CS_3(17279),
    PCO_DIMAX_CS_4(17535),
    PCO_PANDA_42(0),
    PCO_PANDA_42_BI(1),
    PCO_PANDA_150(2),
    PCO_PANDA_OEM1(3),
    PCO_EDGE_SPRINGFIELD(6),
    PCO_EDGE_31(49),
    PCO_EDGE_42(66),
    PCO_EDGE_55(85),
    PCO_EDGE_DEVELOPMENT(256),
    PCO_EDGE_X2(512),
    PCO_EDGE_RESOLFT(768),
    PCO_EDGE_GOLD(4080),
    PCO_EDGE_DUAL_CLOCK(13),
    PCO_EDGE_DICAM(56320),
    PCO_EDGE_42_LT(32834),
    PCO_EDGE_42_BI(1),
    PCO_EDGE_260(2),
    PCO_DICAM_C1(1),
    PCO_DICAM_C2(2),
    PCO_DICAM_C3(3),
    PCO_DICAM_C4(4);

    private int value;

    private CameraSubtype(int value) {
        this.value = value;
    }

    public static CameraSubtype valueOf(int value, CameraType familyType) throws IllegalArgumentException {
        switch (familyType) {
            case PCO_FAMILY_DIMAX: {
                switch (value) {
                    case 100: {
                        return PCO_DIMAX_Weisscam;
                    }
                    case 33023: {
                        return PCO_DIMAX_HD;
                    }
                    case 49407: {
                        return PCO_DIMAX_HD_PLUS;
                    }
                    case 200: {
                        return PCO_DIMAX_X35;
                    }
                    case 8319: {
                        return PCO_DIMAX_HS1;
                    }
                    case 8575: {
                        return PCO_DIMAX_HS2;
                    }
                    case 9087: {
                        return PCO_DIMAX_HS4;
                    }
                    case 16511: {
                        return PCO_DIMAX_CS_AM_DEPRECATED;
                    }
                    case 16767: {
                        return PCO_DIMAX_CS_1;
                    }
                    case 17023: {
                        return PCO_DIMAX_CS_2;
                    }
                    case 17279: {
                        return PCO_DIMAX_CS_3;
                    }
                    case 17535: {
                        return PCO_DIMAX_CS_4;
                    }
                }
                throw new IllegalArgumentException("incorrect camera subtype constant number");
            }
            case PCO_FAMILY_EDGE: {
                switch (value) {
                    case 6: {
                        return PCO_EDGE_SPRINGFIELD;
                    }
                    case 49: {
                        return PCO_EDGE_31;
                    }
                    case 66: {
                        return PCO_EDGE_42;
                    }
                    case 85: {
                        return PCO_EDGE_55;
                    }
                    case 256: {
                        return PCO_EDGE_DEVELOPMENT;
                    }
                    case 512: {
                        return PCO_EDGE_X2;
                    }
                    case 768: {
                        return PCO_EDGE_RESOLFT;
                    }
                    case 4080: {
                        return PCO_EDGE_GOLD;
                    }
                    case 13: {
                        return PCO_EDGE_DUAL_CLOCK;
                    }
                    case 56320: {
                        return PCO_EDGE_DICAM;
                    }
                    case 32834: {
                        return PCO_EDGE_42_LT;
                    }
                    case 1: {
                        return PCO_EDGE_42_BI;
                    }
                    case 2: {
                        return PCO_EDGE_260;
                    }
                }
                throw new IllegalArgumentException("incorrect camera subtype constant number");
            }
            case PCO_FAMILY_PANDA: {
                switch (value) {
                    case 0: {
                        return PCO_PANDA_42;
                    }
                    case 1: {
                        return PCO_PANDA_42_BI;
                    }
                    case 2: {
                        return PCO_PANDA_150;
                    }
                    case 3: {
                        return PCO_PANDA_OEM1;
                    }
                }
                throw new IllegalArgumentException("incorrect camera subtype constant number");
            }
            case PCO_FAMILY_DICAM: {
                switch (value) {
                    case 1: {
                        return PCO_DICAM_C1;
                    }
                    case 2: {
                        return PCO_DICAM_C2;
                    }
                    case 3: {
                        return PCO_DICAM_C3;
                    }
                    case 4: {
                        return PCO_DICAM_C4;
                    }
                }
                throw new IllegalArgumentException("incorrect camera subtype constant number");
            }
        }
        return UNDEFINED;
    }

    public int getValue() {
        return this.value;
    }
}

