/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.AbstractMetadata;
import de.pco.common.MetadataBean;
import de.pco.imageio.PcoIIOMetadata;
import de.pco.imageio.RawImageInputStream;
import de.pco.imageio.RawImageReaderSpi;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;

public class RawImageReader
extends ImageReader {
    private RawImageInputStream input;

    public RawImageReader() {
        super(new RawImageReaderSpi());
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.input = null;
            return;
        }
        if (!(input instanceof RawImageInputStream)) {
            throw new IllegalArgumentException("input not an RawImageInputStream!");
        }
        this.input = (RawImageInputStream)input;
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        if (this.input == null) {
            throw new IllegalStateException("No input source set!");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        return this.input.getNumImages();
    }

    private void checkIndex(int imageIndex) {
        if (this.input == null) {
            throw new IllegalStateException("No input source set!");
        }
        if (imageIndex < 0 || imageIndex > this.getNumImages(true)) {
            throw new IndexOutOfBoundsException("bad index");
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.input.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        return this.input.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        int datatype;
        this.checkIndex(imageIndex);
        ImageTypeSpecifier imageType = null;
        if (this.input.isCompressed()) {
            datatype = 0;
            imageType = ImageTypeSpecifier.createGrayscale(8, datatype, false);
        } else {
            datatype = 1;
            imageType = ImageTypeSpecifier.createGrayscale(16, datatype, false);
        }
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        l.add(imageType);
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        AbstractMetadata metadata = this.input.getMetadata(imageIndex);
        if (metadata != null) {
            MetadataBean metadataBean = metadata.getMetadataBean();
            return new PcoIIOMetadata(metadataBean);
        }
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.input.openSubstreamOnImage(imageIndex);
        Rectangle sourceRegion = RawImageReader.getSourceRegion(param, this.input.getWidth(), this.input.getHeight());
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        Point destinationOffset = new Point(0, 0);
        if (param != null) {
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            destinationOffset = param.getDestinationOffset();
        }
        BufferedImage dst = RawImageReader.getDestination(param, this.getImageTypes(0), this.input.getWidth(), this.input.getHeight());
        int inputBands = 1;
        RawImageReader.checkReadParamBandSettings(param, inputBands, dst.getSampleModel().getNumBands());
        int[] bandOffsets = new int[inputBands];
        for (int i = 0; i < inputBands; ++i) {
            bandOffsets[i] = i;
        }
        int samplesPerRow = this.input.getWidth() * inputBands;
        DataBuffer rowDB = null;
        Object[] rowBuf = null;
        if (this.input.isCompressed()) {
            rowDB = new DataBufferByte(samplesPerRow);
            rowBuf = ((DataBufferByte)rowDB).getData();
        } else {
            rowDB = new DataBufferUShort(samplesPerRow);
            rowBuf = ((DataBufferUShort)rowDB).getData();
        }
        WritableRaster rowRas = Raster.createInterleavedRaster(rowDB, this.input.getWidth(), 1, samplesPerRow, inputBands, bandOffsets, new Point(0, 0));
        int[] pixel = rowRas.getPixel(0, 0, (int[])null);
        WritableRaster imRas = dst.getWritableTile(0, 0);
        int dstMinX = imRas.getMinX();
        int dstMaxX = dstMinX + imRas.getWidth() - 1;
        int dstMinY = imRas.getMinY();
        int dstMaxY = dstMinY + imRas.getHeight() - 1;
        if (sourceBands != null) {
            rowRas = rowRas.createWritableChild(0, 0, this.input.getWidth(), 1, 0, 0, sourceBands);
        }
        if (destinationBands != null) {
            imRas = imRas.createWritableChild(0, 0, imRas.getWidth(), imRas.getHeight(), 0, 0, destinationBands);
        }
        block3: for (int srcY = 0; srcY < this.input.getHeight(); ++srcY) {
            int dstY;
            try {
                if (this.input.isCompressed()) {
                    this.input.readFully((byte[])rowBuf);
                } else {
                    short[] rowShortBuf = rowBuf;
                    this.input.readFully(rowShortBuf, 0, rowShortBuf.length);
                }
            }
            catch (IOException e) {
                throw new IIOException("Error reading line " + srcY, e);
            }
            if (srcY < sourceRegion.y || srcY >= sourceRegion.y + sourceRegion.height || (srcY - sourceRegion.y) % sourceYSubsampling != 0 || (dstY = destinationOffset.y + (srcY - sourceRegion.y) / sourceYSubsampling) < dstMinY) continue;
            if (dstY > dstMaxY) break;
            for (int srcX = sourceRegion.x; srcX < sourceRegion.x + sourceRegion.width; ++srcX) {
                int dstX;
                if ((srcX - sourceRegion.x) % sourceXSubsampling != 0 || (dstX = destinationOffset.x + (srcX - sourceRegion.x) / sourceXSubsampling) < dstMinX) continue;
                if (dstX > dstMaxX) continue block3;
                rowRas.getPixel(srcX, 0, pixel);
                imRas.setPixel(dstX, dstY, pixel);
            }
        }
        return dst;
    }
}

