/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import de.pco.common.AbstractImageData;
import de.pco.common.AbstractMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public class RawImageInputStream
implements ImageInputStream {
    private boolean compressed;
    private int width;
    private int height;
    private List<AbstractImageData> images;
    private ImageInputStream externalIis;
    private ImageInputStream currentImageIis;
    private int currentImageIndex = -1;
    private ByteOrder customGlobalByteOrder;

    public RawImageInputStream(List<AbstractImageData> images) {
        if (images == null || images.size() == 0) {
            throw new IllegalArgumentException("parameter images can not be null or empty");
        }
        this.images = images;
        this.width = images.get(0).getWidth();
        this.height = images.get(0).getHeight();
        this.compressed = images.get(0).isCompressed();
    }

    public RawImageInputStream(AbstractImageData image) {
        this(Arrays.asList(image));
        try {
            this.openSubstreamOnImage(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    RawImageInputStream(ImageInputStream externalIis, int width, int height, boolean compressed) {
        if (externalIis == null) {
            throw new IllegalArgumentException("externalIis can not be null");
        }
        this.width = width;
        this.height = height;
        this.compressed = compressed;
        this.externalIis = externalIis;
        try {
            this.openSubstreamOnImage(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkSubstreamOpened() throws IOException {
        if (this.currentImageIis == null) {
            throw new IllegalStateException("open a substream on a particular image first");
        }
    }

    @Override
    public int read() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.read(b, off, len);
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumImages() {
        if (this.externalIis != null) {
            return 1;
        }
        return this.images.size();
    }

    private void checkIndex(int imageIndex) {
        int maxIndex = -1;
        maxIndex = this.externalIis != null ? 0 : this.images.size() - 1;
        if (imageIndex < 0 || imageIndex > maxIndex) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
    }

    public AbstractMetadata getMetadata(int imageIndex) {
        if (this.externalIis != null) {
            return null;
        }
        this.checkIndex(imageIndex);
        AbstractImageData aid = this.images.get(imageIndex);
        return aid.getMetadata();
    }

    public void openSubstreamOnImage(int index) throws IOException {
        this.checkIndex(index);
        if (this.currentImageIndex == index) {
            this.currentImageIis.reset();
            this.currentImageIis.mark();
            return;
        }
        if (this.externalIis != null) {
            this.currentImageIis = this.externalIis;
            this.currentImageIis.mark();
            this.currentImageIndex = index;
            return;
        }
        if (this.currentImageIis != null) {
            this.currentImageIis.close();
        }
        AbstractImageData aid = this.images.get(index);
        InputStream is = aid.getInputStream();
        this.currentImageIis = ImageIO.createImageInputStream(is);
        if (this.customGlobalByteOrder != null) {
            this.currentImageIis.setByteOrder(this.customGlobalByteOrder);
        }
        this.currentImageIis.mark();
        this.currentImageIndex = index;
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.customGlobalByteOrder = byteOrder;
        if (this.currentImageIis != null) {
            this.currentImageIis.setByteOrder(byteOrder);
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        if (this.customGlobalByteOrder != null) {
            return this.customGlobalByteOrder;
        }
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return null;
        }
        return this.currentImageIis.getByteOrder();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.read(b);
    }

    @Override
    public void readBytes(IIOByteBuffer buf, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readBytes(buf, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readUTF();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(b);
    }

    @Override
    public void readFully(short[] s, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(s, off, len);
    }

    @Override
    public void readFully(char[] c, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(c, off, len);
    }

    @Override
    public void readFully(int[] i, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(i, off, len);
    }

    @Override
    public void readFully(long[] l, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(l, off, len);
    }

    @Override
    public void readFully(float[] f, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(f, off, len);
    }

    @Override
    public void readFully(double[] d, int off, int len) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.readFully(d, off, len);
    }

    @Override
    public long getStreamPosition() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.getStreamPosition();
    }

    @Override
    public int getBitOffset() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.getBitOffset();
    }

    @Override
    public void setBitOffset(int bitOffset) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.setBitOffset(bitOffset);
    }

    @Override
    public int readBit() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readBit();
    }

    @Override
    public long readBits(int numBits) throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.readBits(numBits);
    }

    @Override
    public long length() throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.length();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.skipBytes(n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        this.checkSubstreamOpened();
        return this.currentImageIis.skipBytes(n);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.seek(pos);
    }

    @Override
    public void mark() {
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return;
        }
        this.currentImageIis.mark();
    }

    @Override
    public void reset() throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.reset();
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.flushBefore(pos);
    }

    @Override
    public void flush() throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.flush();
    }

    @Override
    public long getFlushedPosition() {
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return -1L;
        }
        return this.currentImageIis.getFlushedPosition();
    }

    @Override
    public boolean isCached() {
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return false;
        }
        return this.currentImageIis.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return false;
        }
        return this.currentImageIis.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        if (this.currentImageIis == null) {
            System.err.println("illegal object state - open substream on a particular image first");
            return false;
        }
        return this.currentImageIis.isCachedFile();
    }

    @Override
    public void close() throws IOException {
        this.checkSubstreamOpened();
        this.currentImageIis.close();
        this.currentImageIis = null;
        this.currentImageIndex = -1;
    }
}

