/*
 * Decompiled with CFR 0.152.
 */
package de.pco.imageio;

import com.twelvemonkeys.imageio.metadata.tiff.TIFFEntry;
import com.twelvemonkeys.imageio.plugins.tiff.TIFFImageMetadata;
import de.pco.common.MetadataBean;
import de.pco.common.SRGBColorCorrectionCoefficients;
import de.pco.common.Timestamp;
import de.pco.imageio.B16ImageReader;
import de.pco.imageio.B16ImageWriterSpi;
import de.pco.imageio.PcoIIOMetadata;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class B16ImageWriter
extends ImageWriter {
    ImageOutputStream output = null;

    public B16ImageWriter() {
        super(new B16ImageWriterSpi());
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output not an ImageOutputStream!");
            }
            this.output = (ImageOutputStream)output;
            this.output.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.output = null;
        }
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new PcoIIOMetadata(new MetadataBean());
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData instanceof PcoIIOMetadata) {
            return inData;
        }
        if (inData instanceof TIFFImageMetadata) {
            MetadataBean metadataBean = null;
            TIFFImageMetadata tiffMetadata = (TIFFImageMetadata)inData;
            TIFFEntry tf1 = (TIFFEntry)tiffMetadata.getTIFFField(50495);
            if (tf1 != null) {
                byte[] ba = null;
                ByteArrayInputStream bis = null;
                if (tf1.getType() == 1) {
                    ba = (byte[])tf1.getValue();
                    bis = new ByteArrayInputStream(ba);
                    bis.skip(4L);
                } else {
                    int[] b = (int[])tf1.getValue();
                    ByteBuffer bb = ByteBuffer.allocate(b.length * 2);
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                    for (int i = 0; i < b.length; ++i) {
                        bb.putShort(i * 2, (short)b[i]);
                    }
                    ba = new byte[bb.limit()];
                    bb.get(ba);
                    bis = new ByteArrayInputStream(ba);
                    bis.skip(2L);
                }
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(bis);
                    iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    metadataBean = B16ImageReader.loadMetadataFromBildStruct(iis);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                metadataBean = new MetadataBean();
                TIFFEntry tf = (TIFFEntry)tiffMetadata.getTIFFField(256);
                metadataBean.xRes = (int)((Long)tf.getValue()).longValue();
                tf = (TIFFEntry)tiffMetadata.getTIFFField(257);
                metadataBean.yRes = (int)((Long)tf.getValue()).longValue();
                tf = (TIFFEntry)tiffMetadata.getTIFFField(258);
                metadataBean.bitRes = tf.getValue() instanceof Integer ? (Integer)tf.getValue() : ((int[])tf.getValue())[0];
                tf = (TIFFEntry)tiffMetadata.getTIFFField(262);
                int phInterpretation = (Integer)tf.getValue();
                if (phInterpretation == 2) {
                    metadataBean.isColor = true;
                }
            }
            PcoIIOMetadata pcoMetadata = new PcoIIOMetadata(metadataBean);
            return pcoMetadata;
        }
        return null;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        RenderedImage im = image.getRenderedImage();
        Rectangle sourceRegion = new Rectangle(0, 0, im.getWidth(), im.getHeight());
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        if (param != null) {
            sourceRegion = sourceRegion.intersection(param.getSourceRegion());
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            sourceBands = param.getSourceBands();
            int subsampleXOffset = param.getSubsamplingXOffset();
            int subsampleYOffset = param.getSubsamplingYOffset();
            sourceRegion.x += subsampleXOffset;
            sourceRegion.y += subsampleYOffset;
            sourceRegion.width -= subsampleXOffset;
            sourceRegion.height -= subsampleYOffset;
        }
        int width = sourceRegion.width;
        int height = sourceRegion.height;
        Raster imRas = im.getData(sourceRegion);
        int numBands = imRas.getNumBands();
        if (sourceBands != null) {
            for (int i = 0; i < sourceBands.length; ++i) {
                if (sourceBands[i] < numBands) continue;
                throw new IllegalArgumentException("bad band!");
            }
        }
        imRas = imRas.createChild(sourceRegion.x, sourceRegion.y, width, height, 0, 0, sourceBands);
        width = (width + sourceXSubsampling - 1) / sourceXSubsampling;
        height = (height + sourceYSubsampling - 1) / sourceYSubsampling;
        if (numBands != 1) {
            throw new IIOException("Image must be grayscale!");
        }
        int dataType = imRas.getDataBuffer().getDataType();
        if (dataType != 1) {
            throw new IIOException("The resolution of the image must be 16 bit!");
        }
        try {
            IIOMetadata imd = image.getMetadata();
            PcoIIOMetadata metadata = null;
            if (imd != null) {
                ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(im);
                metadata = (PcoIIOMetadata)this.convertImageMetadata(imd, type, null);
            }
            this.output.mark();
            byte[] signature = new byte[]{80, 67, 79, 45};
            this.output.write(signature);
            int HEADER_SIZE = 1024;
            int filesize = 1024 + width * height * 2;
            int lookup = 1;
            int doubleShutter = 0;
            if (metadata != null && metadata.getMetadataBean().isDouble) {
                doubleShutter = 21316;
            }
            this.output.writeInt(filesize);
            this.output.writeInt(1024);
            this.output.writeInt(width);
            this.output.writeInt(height);
            this.output.writeInt(lookup);
            this.output.writeInt(doubleShutter);
            this.output.reset();
            this.output.mark();
            this.output.skipBytes(128);
            if (metadata == null) {
                this.output.skipBytes(896);
            } else if (metadata != null) {
                int i;
                MetadataBean metadataBean = metadata.getMetadataBean();
                Timestamp timestamp = metadataBean.time;
                this.output.writeShort(timestamp.year);
                this.output.writeShort(timestamp.month);
                this.output.writeShort(timestamp.dayOfWeek);
                this.output.writeShort(timestamp.day);
                this.output.writeShort(timestamp.hour);
                this.output.writeShort(timestamp.minute);
                this.output.writeShort(timestamp.second);
                this.output.writeShort(timestamp.milliseconds);
                this.output.writeInt(metadataBean.ticks);
                this.output.writeInt(metadataBean.xRes);
                this.output.writeInt(metadataBean.yRes);
                String formatted = this.rightPadding(metadataBean.text, 40, '\u0000');
                this.output.writeBytes(formatted);
                this.output.writeBoolean(metadataBean.isDouble);
                this.output.writeBoolean(metadataBean.thisIsT0);
                this.output.writeBoolean(metadataBean.weHaveT0);
                this.output.write(0);
                this.output.writeInt(metadataBean.bwMin);
                this.output.writeInt(metadataBean.bwMax);
                this.output.writeInt(metadataBean.bwLut);
                this.output.writeInt(metadataBean.rMin);
                this.output.writeInt(metadataBean.rMax);
                this.output.writeInt(metadataBean.gMin);
                this.output.writeInt(metadataBean.gMax);
                this.output.writeInt(metadataBean.bMin);
                this.output.writeInt(metadataBean.bMax);
                this.output.writeInt(metadataBean.colLut);
                if (metadataBean.isColor) {
                    this.output.writeInt(1);
                } else {
                    this.output.writeInt(0);
                }
                this.output.writeInt(metadataBean.version.getValue());
                this.output.writeInt(metadataBean.bwMin2);
                this.output.writeInt(metadataBean.bwMax2);
                this.output.writeInt(metadataBean.bwLut2);
                this.output.writeInt(metadataBean.rMin2);
                this.output.writeInt(metadataBean.rMax2);
                this.output.writeInt(metadataBean.gMin2);
                this.output.writeInt(metadataBean.gMax2);
                this.output.writeInt(metadataBean.bMin2);
                this.output.writeInt(metadataBean.bMax2);
                this.output.writeInt(metadataBean.colLut2);
                this.output.writeBoolean(metadataBean.alignUpper);
                this.output.write(new byte[]{0, 0, 0});
                this.output.writeDouble(metadataBean.gammaLut);
                this.output.writeDouble(metadataBean.gammaLutC);
                this.output.writeDouble(metadataBean.gammaLut2);
                this.output.writeDouble(metadataBean.gammaLutC2);
                this.output.writeInt(metadataBean.colorPatternType.getValue());
                this.output.writeInt(metadataBean.bitRes);
                this.output.writeDouble(metadataBean.dSaturation);
                this.output.writeInt(metadataBean.iSaturation);
                this.output.writeInt(metadataBean.vibrance);
                this.output.writeInt(metadataBean.colorTemp);
                this.output.writeInt(metadataBean.colorTint);
                this.output.writeInt(metadataBean.contrast);
                this.output.writeInt(metadataBean.gamma);
                SRGBColorCorrectionCoefficients ccc = metadataBean.colorCoeff;
                this.output.writeDouble(ccc.a11);
                this.output.writeDouble(ccc.a12);
                this.output.writeDouble(ccc.a13);
                this.output.writeDouble(ccc.a21);
                this.output.writeDouble(ccc.a22);
                this.output.writeDouble(ccc.a23);
                this.output.writeDouble(ccc.a31);
                this.output.writeDouble(ccc.a32);
                this.output.writeDouble(ccc.a33);
                this.output.writeInt(metadataBean.timestampPosition.getValue());
                if (!metadataBean.hasMetaData) {
                    this.output.writeShort(0);
                } else {
                    this.output.writeShort(1);
                }
                this.output.writeShort(metadataBean.sensorConvFactor);
                this.output.writeShort(metadataBean.cameraType.getValue());
                this.output.writeShort(metadataBean.darkOffset);
                long hlp = metadataBean.imageCounter;
                int pairToConvert = -1;
                int result = -1;
                for (i = 0; i < 4; ++i) {
                    pairToConvert = (byte)(hlp % 100L);
                    result = (byte)((byte)(pairToConvert / 10) << 4);
                    result = (byte)(result + (byte)(pairToConvert % 10));
                    this.output.write(result);
                    hlp /= 100L;
                }
                hlp = metadataBean.imageTimeUs;
                pairToConvert = -1;
                result = -1;
                for (i = 0; i < 3; ++i) {
                    pairToConvert = (byte)(hlp % 100L);
                    result = (byte)((byte)(pairToConvert / 10) << 4);
                    result = (byte)(result + (byte)(pairToConvert % 10));
                    this.output.write(result);
                    hlp /= 100L;
                }
                this.output.write(metadataBean.imageTimeStatus.getValue());
                this.output.writeShort(metadataBean.exposureTimebase.getValue());
                this.output.writeShort(metadataBean.sensorTemperature);
                this.output.writeInt((int)metadataBean.exposureTime);
                this.output.writeInt((int)metadataBean.framerateMilliHz);
                this.output.writeByte(metadataBean.binningX);
                this.output.writeByte(metadataBean.binningY);
                this.output.writeByte(metadataBean.triggerMode.getValue());
                this.output.writeByte(metadataBean.cameraSyncMode.getValue());
                this.output.writeInt((int)metadataBean.sensorReadoutFrequency);
                this.output.writeInt((int)metadataBean.cameraSerialNo);
                this.output.writeByte(metadataBean.syncStatus.getValue());
                this.output.writeByte(metadataBean.imageType.getValue());
                this.output.writeShort(metadataBean.colorPattern);
                this.output.writeShort(metadataBean.cameraSubtype.getValue());
                this.output.write(new byte[]{0, 0});
                this.output.writeInt((int)metadataBean.eventNumber);
                this.output.writeShort(metadataBean.imageSizeXoffset);
                this.output.writeShort(metadataBean.imageSizeYoffset);
                for (i = 0; i < 64; ++i) {
                    this.output.write(0);
                }
                this.output.writeInt((int)metadataBean.compression);
                this.output.writeInt((int)metadataBean.compressionVersion);
                this.output.writeInt((int)metadataBean.predictorStart);
                this.output.writeInt((int)metadataBean.randomStart);
                this.output.writeInt((int)metadataBean.randomIndex);
                this.output.writeInt(metadataBean.diffToT0);
                this.output.reset();
                this.output.skipBytes(1024);
            }
            int rowLength = width * numBands;
            int xSkip = sourceXSubsampling * numBands;
            int[] rowPixels = imRas.getPixels(0, 0, width, 1, (int[])null);
            short[] rowSamples = new short[rowLength];
            for (int y = 0; y < height; y += sourceYSubsampling) {
                imRas.getPixels(0, y, width, 1, rowPixels);
                int count = 0;
                for (int x = 0; x < width; x += xSkip) {
                    rowSamples[count++] = (short)rowPixels[x];
                }
                this.output.writeShorts(rowSamples, 0, width * numBands);
            }
            this.output.flush();
        }
        catch (IOException e) {
            throw new IIOException("I/O error!", e);
        }
    }

    private String rightPadding(String word, int length, char ch) {
        return length > word.length() ? this.rightPadding(word + ch, length, ch) : word;
    }
}

