/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common.enums;

public enum TimestampPosition {
    NONE(0),
    LEFT_TOP(1406),
    MIRROR(66942),
    FLIP(132478),
    MIRROR_FLIP(198014),
    NOT_IMPORTANT(263550),
    UNDEFINED(524287);

    private int value;

    private TimestampPosition(int value) {
        this.value = value;
    }

    public static TimestampPosition valueOf(int value) throws IllegalArgumentException {
        if (value == 0) {
            return NONE;
        }
        int maskedValue = value & 0xF0000;
        switch (maskedValue) {
            case 0: {
                return LEFT_TOP;
            }
            case 65536: {
                return MIRROR;
            }
            case 131072: {
                return FLIP;
            }
            case 196608: {
                return MIRROR_FLIP;
            }
            case 262144: {
                return NOT_IMPORTANT;
            }
        }
        return UNDEFINED;
    }

    public int getValue() {
        return this.value;
    }
}

