/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.AbstractUnsignedArray;
import java.nio.ByteBuffer;

public class UShortArray
extends AbstractUnsignedArray {
    public static final int ELEMENT_MAX_VALUE = 65535;

    public UShortArray(short[] shortArray) {
        super((Object)shortArray);
        if (shortArray == null) {
            throw new IllegalArgumentException("short array can not be null");
        }
        this.buffer = ByteBuffer.allocate(shortArray.length * 2);
        this.buffer.asShortBuffer().put(shortArray);
    }

    public UShortArray(int[] intArray) throws IllegalArgumentException {
        super(intArray);
        if (intArray == null) {
            throw new IllegalArgumentException("int array can not be null");
        }
        for (int i = 0; i < intArray.length; ++i) {
            if (intArray[i] >= 0 && intArray[i] <= 65535) continue;
            throw new IllegalArgumentException("Array contains values larger than 65535");
        }
        short[] shortArray = new short[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            shortArray[i] = (short)intArray[i];
        }
        this.buffer = ByteBuffer.allocate(shortArray.length * 2);
        this.buffer.asShortBuffer().put(shortArray);
    }

    @Override
    public int[] getArray() {
        short[] backingArray = this.getBackingArray();
        int[] array = new int[backingArray.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Short.toUnsignedInt(backingArray[i]);
        }
        return array;
    }

    public short[] getBackingArray() {
        short[] retArray = new short[this.buffer.capacity() / 2];
        this.buffer.asShortBuffer().get(retArray);
        return retArray;
    }

    @Override
    public int length() {
        return this.buffer.capacity() / 2;
    }
}

