/*
 * Decompiled with CFR 0.152.
 */
package de.pco.common;

import de.pco.common.AbstractUnsignedArray;
import java.nio.ByteBuffer;

public class UByteArray
extends AbstractUnsignedArray {
    public static final int ELEMENT_MAX_VALUE = 255;

    public UByteArray(byte[] byteArray) {
        super((Object)byteArray);
        if (byteArray == null) {
            throw new IllegalArgumentException("byte array can not be null");
        }
        this.buffer = ByteBuffer.wrap(byteArray);
    }

    public UByteArray(int[] intArray) throws IllegalArgumentException {
        super(intArray);
        if (intArray == null) {
            throw new IllegalArgumentException("int array can not be null");
        }
        for (int i = 0; i < intArray.length; ++i) {
            if (intArray[i] >= 0 && intArray[i] <= 255) continue;
            throw new IllegalArgumentException("Array contains values larger than 255");
        }
        byte[] byteArray = new byte[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            byteArray[i] = (byte)intArray[i];
        }
        this.buffer = ByteBuffer.wrap(byteArray);
    }

    @Override
    public int[] getArray() {
        byte[] backingArray = this.getBackingArray();
        int[] array = new int[backingArray.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Byte.toUnsignedInt(backingArray[i]);
        }
        return array;
    }

    public byte[] getBackingArray() {
        return this.buffer.array();
    }

    @Override
    public int length() {
        return this.buffer.capacity();
    }
}

