/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.lang.Validate;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

final class ExtraSamplesColorModel
extends ComponentColorModel {
    private final int numComponents;
    private final int componentSize;

    ExtraSamplesColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        super(colorSpace, bl, bl2, 3, n);
        Validate.isTrue(n2 > 0, "Extra components must be > 0");
        this.numComponents = colorSpace.getNumComponents() + (bl ? 1 : 0) + n2;
        this.componentSize = DataBuffer.getDataTypeSize(n);
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Override
    public int getComponentSize(int n) {
        return this.componentSize;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return this.numComponents == sampleModel.getNumBands() && this.transferType == sampleModel.getTransferType();
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{this.getAlphaComponent()};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    private int getAlphaComponent() {
        return super.getNumComponents() - 1;
    }
}

