/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.indicator;

import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MutableStatusDetailIndicator
implements StatusDetailIndicator {
    private volatile StatusDetail statusDetail;

    public MutableStatusDetailIndicator(StatusDetail initialStatusDetail) {
        this.statusDetail = Objects.requireNonNull(initialStatusDetail, "Initial StatusDetail must not be null");
    }

    @Override
    public StatusDetail statusDetail() {
        return this.statusDetail;
    }

    public void update(StatusDetail statusDetail) {
        if (!this.statusDetail.getName().equals(statusDetail.getName())) {
            throw new IllegalArgumentException("Must not update StatusDetail with different names. That would be confusing.");
        }
        this.statusDetail = Objects.requireNonNull(statusDetail, "Parameter StatusDetail must not be null");
    }

    public void toOk(String message) {
        this.update(this.statusDetail.toOk(message));
    }

    public void toWarning(String message) {
        this.update(this.statusDetail.toWarning(message));
    }

    public void toError(String message) {
        this.update(this.statusDetail.toError(message));
    }

    public void withDetail(String key, String value) {
        this.update(this.statusDetail.withDetail(key, value));
    }

    public void withoutDetail(String key) {
        this.update(this.statusDetail.withoutDetail(key));
    }
}

