/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.indicator;

import de.otto.edison.status.domain.ApplicationInfo;
import de.otto.edison.status.domain.ApplicationStatus;
import de.otto.edison.status.domain.ServiceSpec;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.domain.SystemInfo;
import de.otto.edison.status.domain.TeamInfo;
import de.otto.edison.status.domain.VersionInfo;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;

public class CachedApplicationStatusAggregator
implements ApplicationStatusAggregator {
    private volatile ApplicationStatus cachedStatus;
    private final ApplicationInfo applicationInfo;
    private final SystemInfo systemInfo;
    private final VersionInfo versionInfo;
    private final TeamInfo teamInfo;
    private final List<StatusDetailIndicator> indicators;
    private final List<ServiceSpec> serviceSpecs;

    public CachedApplicationStatusAggregator(ApplicationInfo applicationInfo, SystemInfo systemInfo, VersionInfo versionInfo, TeamInfo teamInfo, List<StatusDetailIndicator> indicators, List<ServiceSpec> serviceSpecs) {
        this.applicationInfo = applicationInfo;
        this.systemInfo = systemInfo;
        this.versionInfo = versionInfo;
        this.teamInfo = teamInfo;
        this.indicators = indicators;
        this.serviceSpecs = serviceSpecs;
    }

    @PostConstruct
    public void postConstruct() {
        this.update();
    }

    @Override
    public ApplicationStatus aggregatedStatus() {
        return this.cachedStatus;
    }

    @Override
    public void update() {
        this.cachedStatus = ApplicationStatus.applicationStatus(this.applicationInfo, this.systemInfo, this.versionInfo, this.teamInfo, CachedApplicationStatusAggregator.getStatusDetails(this.indicators), this.serviceSpecs);
    }

    private static List<StatusDetail> getStatusDetails(List<StatusDetailIndicator> indicators) {
        return indicators.stream().flatMap(i -> i.statusDetails().stream()).collect(Collectors.toList());
    }
}

