/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import net.jcip.annotations.Immutable;

@Immutable
public class VersionInfo {
    public final String version;
    public final String commit;
    public final String url;

    private VersionInfo(String version, String commit, String vcsUrlTemplate) {
        this.version = version;
        this.commit = commit;
        this.url = vcsUrlTemplate.isEmpty() ? "" : vcsUrlTemplate.replace("{commit}", commit).replace("{version}", version);
    }

    public static VersionInfo versionInfo(String version, String commit, String vcsUrlTemplate) {
        return new VersionInfo(version, commit, vcsUrlTemplate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionInfo that = (VersionInfo)o;
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.commit != null ? !this.commit.equals(that.commit) : that.commit != null) {
            return false;
        }
        return !(this.url == null ? that.url != null : !this.url.equals(that.url));
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.commit != null ? this.commit.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "VersionInfo{version='" + this.version + '\'' + ", commit='" + this.commit + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

