/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import net.jcip.annotations.Immutable;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class SystemInfo {
    private static final OffsetDateTime START_TIME = OffsetDateTime.now();
    public final String hostname;
    public final int port;

    private SystemInfo(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public static SystemInfo systemInfo(String hostname, int port) {
        return new SystemInfo(hostname, port);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getSystemTime() {
        return OffsetDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public String getSystemStartTime() {
        return START_TIME.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public String getSystemUpTime() {
        long seconds = Duration.between(START_TIME, OffsetDateTime.now()).getSeconds();
        return String.format("%d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemInfo that = (SystemInfo)o;
        if (this.port != that.port) {
            return false;
        }
        return !(this.hostname == null ? that.hostname != null : !this.hostname.equals(that.hostname));
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "SystemInfo{hostname='" + this.hostname + '\'' + ", port=" + this.port + '}';
    }
}

