/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.status.domain.Status;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class StatusDetail {
    private final String name;
    private final Status status;
    private final String message;
    private final Map<String, String> details;

    private StatusDetail(String name, Status status, String message, Map<String, String> details) {
        this.name = name;
        this.status = status;
        this.message = message;
        this.details = Collections.unmodifiableMap(new LinkedHashMap<String, String>(details));
    }

    public static StatusDetail statusDetail(String name, Status status, String message) {
        return new StatusDetail(name, status, message, Collections.emptyMap());
    }

    public static StatusDetail statusDetail(String name, Status status, String message, Map<String, String> additionalAttributes) {
        return new StatusDetail(name, status, message, additionalAttributes);
    }

    public StatusDetail toOk(String message) {
        return StatusDetail.statusDetail(this.name, Status.OK, message, this.details);
    }

    public StatusDetail toWarning(String message) {
        return StatusDetail.statusDetail(this.name, Status.WARNING, message, this.details);
    }

    public StatusDetail toError(String message) {
        return StatusDetail.statusDetail(this.name, Status.ERROR, message, this.details);
    }

    public StatusDetail withDetail(String key, String value) {
        LinkedHashMap<String, String> newDetails = new LinkedHashMap<String, String>(this.details);
        newDetails.put(key, value);
        return StatusDetail.statusDetail(this.name, this.status, this.message, newDetails);
    }

    public StatusDetail withoutDetail(String key) {
        LinkedHashMap<String, String> newDetails = new LinkedHashMap<String, String>(this.details);
        newDetails.remove(key);
        return StatusDetail.statusDetail(this.name, this.status, this.message, newDetails);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDetail that = (StatusDetail)o;
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StatusDetail{name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + ", details=" + this.details + '}';
    }
}

