/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.status.domain.Availability;
import de.otto.edison.status.domain.Performance;
import net.jcip.annotations.Immutable;

@Immutable
public class Expectations {
    public final Availability availability;
    public final Performance performance;

    public static Expectations unspecifiedExpectations() {
        return new Expectations(Availability.NOT_SPECIFIED, Performance.NOT_SPECIFIED);
    }

    public static Expectations lowExpectations() {
        return new Expectations(Availability.LOW, Performance.LOW);
    }

    public static Expectations highExpectations() {
        return new Expectations(Availability.HIGH, Performance.HIGH);
    }

    public static Expectations expects(Availability availability, Performance performance) {
        return new Expectations(availability, performance);
    }

    private Expectations(Availability availability, Performance performance) {
        this.availability = availability;
        this.performance = performance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expectations that = (Expectations)o;
        if (this.availability != that.availability) {
            return false;
        }
        return this.performance == that.performance;
    }

    public int hashCode() {
        int result = this.availability != null ? this.availability.hashCode() : 0;
        result = 31 * result + (this.performance != null ? this.performance.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Expectations{availability=" + (Object)((Object)this.availability) + ", performance=" + (Object)((Object)this.performance) + '}';
    }
}

