/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.status.domain.ApplicationInfo;
import de.otto.edison.status.domain.ServiceSpec;
import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.domain.SystemInfo;
import de.otto.edison.status.domain.TeamInfo;
import de.otto.edison.status.domain.VersionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;

@Immutable
public final class ApplicationStatus {
    public final ApplicationInfo application;
    public final SystemInfo system;
    public final VersionInfo vcs;
    public final TeamInfo team;
    public final Status status;
    public final List<StatusDetail> statusDetails;
    public final List<ServiceSpec> serviceSpecs;

    private ApplicationStatus(ApplicationInfo application, SystemInfo system, VersionInfo vcs, TeamInfo team, List<StatusDetail> details, List<ServiceSpec> serviceSpecs) {
        this.status = details.stream().map(StatusDetail::getStatus).reduce(Status.OK, Status::plus);
        this.statusDetails = Collections.unmodifiableList(new ArrayList<StatusDetail>(details));
        this.application = application;
        this.system = system;
        this.vcs = vcs;
        this.team = team;
        this.serviceSpecs = serviceSpecs != null ? serviceSpecs.stream().sorted(Comparator.comparing(spec -> spec.name)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static ApplicationStatus applicationStatus(ApplicationInfo applicationInfo, SystemInfo systemInfo, VersionInfo versionInfo, TeamInfo teamInfo, List<StatusDetail> details, List<ServiceSpec> serviceSpecs) {
        return new ApplicationStatus(applicationInfo, systemInfo, versionInfo, teamInfo, details, serviceSpecs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationStatus that = (ApplicationStatus)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.system != null ? !this.system.equals(that.system) : that.system != null) {
            return false;
        }
        if (this.vcs != null ? !this.vcs.equals(that.vcs) : that.vcs != null) {
            return false;
        }
        if (this.team != null ? !this.team.equals(that.team) : that.team != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.statusDetails != null ? !this.statusDetails.equals(that.statusDetails) : that.statusDetails != null) {
            return false;
        }
        return !(this.serviceSpecs != null ? !this.serviceSpecs.equals(that.serviceSpecs) : that.serviceSpecs != null);
    }

    public int hashCode() {
        int result = this.application != null ? this.application.hashCode() : 0;
        result = 31 * result + (this.system != null ? this.system.hashCode() : 0);
        result = 31 * result + (this.vcs != null ? this.vcs.hashCode() : 0);
        result = 31 * result + (this.team != null ? this.team.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.statusDetails != null ? this.statusDetails.hashCode() : 0);
        result = 31 * result + (this.serviceSpecs != null ? this.serviceSpecs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApplicationStatus{application=" + this.application + ", system=" + this.system + ", vcs=" + this.vcs + ", team=" + this.team + ", status=" + (Object)((Object)this.status) + ", statusDetails=" + this.statusDetails + ", serviceSpecs=" + this.serviceSpecs + '}';
    }
}

