/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.configuration;

import de.otto.edison.status.domain.SystemInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class SystemInfoConfiguration {
    private static final String defaultHostname;
    @Value(value="${HOSTNAME:}")
    private String hostname;
    @Value(value="${server.hostname:}")
    private String envhostname;
    @Value(value="${server.port:8080}")
    private int port;

    @Bean
    @ConditionalOnMissingBean(value={SystemInfo.class})
    public SystemInfo systemInfo() {
        return SystemInfo.systemInfo(this.hostname(), this.port);
    }

    private String hostname() {
        if (!StringUtils.isEmpty((Object)this.envhostname)) {
            return this.envhostname;
        }
        if (!StringUtils.isEmpty((Object)this.hostname)) {
            return this.hostname;
        }
        return defaultHostname;
    }

    static {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        defaultHostname = localHost;
    }
}

