/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.annotations.Beta;
import de.otto.edison.status.domain.Criticality;
import net.jcip.annotations.Immutable;

@Immutable
@Beta
public class ServiceType {
    public static final String TYPE_REST_SERVICE = "service/rest";
    public static final String TYPE_DATA_IMPORT = "data/import/full";
    public static final String TYPE_DATA_FEED = "data/import/delta";
    public final String type;
    public final Criticality criticality;
    public final String disasterImpact;

    public static ServiceType serviceType(String type, Criticality criticality, String disasterImpact) {
        return new ServiceType(type, criticality, disasterImpact);
    }

    public static ServiceType unspecifiedService() {
        return new ServiceType("not specified", Criticality.NOT_SPECIFIED, "not specified");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceType that = (ServiceType)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.criticality != that.criticality) {
            return false;
        }
        return !(this.disasterImpact == null ? that.disasterImpact != null : !this.disasterImpact.equals(that.disasterImpact));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.criticality != null ? this.criticality.hashCode() : 0);
        result = 31 * result + (this.disasterImpact != null ? this.disasterImpact.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceType{type='" + this.type + '\'' + ", criticality=" + (Object)((Object)this.criticality) + ", disasterImpact='" + this.disasterImpact + '\'' + '}';
    }

    private ServiceType(String type, Criticality criticality, String disasterImpact) {
        this.type = type;
        this.criticality = criticality;
        this.disasterImpact = disasterImpact;
    }
}

