/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.annotations.Beta;
import de.otto.edison.status.domain.Expectations;
import de.otto.edison.status.domain.ServiceType;
import net.jcip.annotations.Immutable;

@Immutable
@Beta
public class ServiceSpec {
    public final String name;
    public final String url;
    public final ServiceType type;
    public final Expectations expectations;

    public static ServiceSpec serviceSpec(String name, String url, ServiceType type, Expectations expectations) {
        return new ServiceSpec(name, url, type, expectations);
    }

    public static ServiceSpec serviceSpec(String name, String url) {
        return new ServiceSpec(name, url, ServiceType.unspecifiedService(), Expectations.unspecifiedExpectations());
    }

    private ServiceSpec(String name, String url, ServiceType type, Expectations expectations) {
        this.name = name;
        this.type = type;
        this.url = url;
        this.expectations = expectations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpec that = (ServiceSpec)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.expectations == null ? that.expectations != null : !this.expectations.equals(that.expectations));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.expectations != null ? this.expectations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServiceSpec{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", type=" + this.type + ", expectations=" + this.expectations + '}';
    }
}

