/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import net.jcip.annotations.Immutable;

@Immutable
public class ApplicationInfo {
    public final String name;
    public final String description;
    public final String group;
    public final String environment;

    private ApplicationInfo(String name, String description, String group, String environment) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name must not be empty");
        }
        this.name = name;
        this.description = description;
        this.group = group;
        this.environment = environment;
    }

    public static ApplicationInfo applicationInfo(String name, String description, String group, String environment) {
        return new ApplicationInfo(name, description, group, environment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationInfo that = (ApplicationInfo)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        return !(this.environment == null ? that.environment != null : !this.environment.equals(that.environment));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApplicationInfo{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", group='" + this.group + '\'' + ", environment='" + this.environment + '\'' + '}';
    }
}

