/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.controller;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.otto.edison.status.domain.ApplicationStatus;
import de.otto.edison.status.domain.ServiceSpec;
import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.domain.SystemInfo;
import de.otto.edison.status.domain.TeamInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusRepresentation {
    private static final Pattern STATUS_DETAIL_JSON_SEPARATOR_PATTERN = Pattern.compile("\\s(.)");
    public ApplicationRepresentation application;
    public SystemInfo system;
    public TeamInfo team;
    public List<ServiceSpec> serviceSpecs;

    private StatusRepresentation(ApplicationStatus applicationStatus) {
        this.application = new ApplicationRepresentation(applicationStatus);
        this.system = applicationStatus.system;
        this.team = applicationStatus.team;
        this.serviceSpecs = applicationStatus.serviceSpecs;
    }

    public static StatusRepresentation statusRepresentationOf(ApplicationStatus status) {
        return new StatusRepresentation(status);
    }

    private Map<String, ?> statusDetailsOf(List<StatusDetail> statusDetails) {
        LinkedHashMap<String, 1> map = new LinkedHashMap<String, 1>();
        for (final StatusDetail entry : statusDetails) {
            map.put(StatusRepresentation.toCamelCase(entry.getName()), new LinkedHashMap<String, String>(){
                {
                    this.put("status", entry.getStatus().name());
                    this.put("message", entry.getMessage());
                    this.putAll(entry.getDetails().entrySet().stream().collect(Collectors.toMap(entry -> StatusRepresentation.toCamelCase((String)entry.getKey()), Map.Entry::getValue)));
                }
            });
        }
        return map;
    }

    private static String toCamelCase(String name) {
        Matcher matcher = STATUS_DETAIL_JSON_SEPARATOR_PATTERN.matcher(name);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        String s = sb.toString();
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    class ApplicationRepresentation {
        public String name;
        public String description;
        public String group;
        public String environment;
        public String version;
        public String commit;
        public String vcsUrl;
        public Status status;
        public Map<String, ?> statusDetails;

        public ApplicationRepresentation() {
        }

        private ApplicationRepresentation(ApplicationStatus applicationStatus) {
            this.name = applicationStatus.application.name;
            this.description = applicationStatus.application.description;
            this.group = applicationStatus.application.group;
            this.environment = applicationStatus.application.environment;
            this.version = applicationStatus.vcs.version;
            this.commit = applicationStatus.vcs.commit;
            this.vcsUrl = applicationStatus.vcs.url;
            this.status = applicationStatus.status;
            this.statusDetails = StatusRepresentation.this.statusDetailsOf(applicationStatus.statusDetails);
        }
    }
}

