/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.controller;

import de.otto.edison.status.controller.StatusRepresentation;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@ConfigurationProperties(value="endpoints.status", ignoreUnknownFields=false)
@RestController
public class StatusController {
    private static final String SYSTEM_START_TIME = ZonedDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG));
    @Autowired
    private ApplicationStatusAggregator aggregator;

    public StatusController() {
    }

    public StatusController(ApplicationStatusAggregator aggregator) {
        this.aggregator = aggregator;
    }

    @RequestMapping(value={"/internal/status"}, produces={"application/vnd.otto.monitoring.status+json", "application/json"}, method={RequestMethod.GET})
    public StatusRepresentation getStatusAsJson() {
        return StatusRepresentation.statusRepresentationOf(this.aggregator.aggregatedStatus());
    }

    @RequestMapping(value={"/internal/status"}, produces={"text/html"}, method={RequestMethod.GET})
    public ModelAndView getStatusAsHtml() {
        return new ModelAndView("status", "status", (Object)this.aggregator.aggregatedStatus());
    }
}

