/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.configuration;

import de.otto.edison.status.domain.ApplicationInfo;
import de.otto.edison.status.domain.ServiceSpec;
import de.otto.edison.status.domain.SystemInfo;
import de.otto.edison.status.domain.TeamInfo;
import de.otto.edison.status.domain.VersionInfo;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import de.otto.edison.status.indicator.CachedApplicationStatusAggregator;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplicationStatusAggregatorConfiguration {
    @Autowired(required=false)
    private List<StatusDetailIndicator> statusDetailIndicators = Collections.emptyList();
    @Autowired(required=false)
    private List<ServiceSpec> serviceSpecs = Collections.emptyList();

    @Bean
    @ConditionalOnMissingBean(value={ApplicationStatusAggregator.class})
    public ApplicationStatusAggregator applicationStatusAggregator(ApplicationInfo applicationInfo, VersionInfo versionInfo, SystemInfo systemInfo, TeamInfo teamInfo) {
        List<StatusDetailIndicator> indicators = this.statusDetailIndicators != null ? this.statusDetailIndicators : Collections.emptyList();
        List<ServiceSpec> services = this.serviceSpecs != null ? this.serviceSpecs : Collections.emptyList();
        return new CachedApplicationStatusAggregator(applicationInfo, systemInfo, versionInfo, teamInfo, indicators, services);
    }
}

