/*
 * Decompiled with CFR 0.152.
 */
package de.oscillation.maven.doxygen;

import de.oscillation.maven.doxygen.AbstractDoxygenMojo;
import de.oscillation.maven.doxygen.DoxygenOutputGenerator;
import java.io.File;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="clean", defaultPhase=LifecyclePhase.CLEAN)
public class DoxygenCleanMojo
extends AbstractDoxygenMojo {
    public void performTasks() {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(this.getWorkingDirectory());
        cl.setExecutable("rm");
        cl.createArg().setValue("-rv");
        for (DoxygenOutputGenerator generator : this.outputGenerators) {
            if (!generator.isActive()) continue;
            String path = this.outputBasePath + File.separator + generator.getOutputPath();
            cl.createArg().setFile(new File(path));
            this.getLog().info((CharSequence)("Cleaning output directory " + path));
        }
        try {
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)this.systemOut, (StreamConsumer)this.systemErr);
            for (String line : this.stringWriter.toString().split("\n")) {
                this.getLog().debug((CharSequence)line);
            }
        }
        catch (CommandLineException e) {
            this.getLog().error((CharSequence)("CommandLineException: " + e.getMessage()));
        }
    }
}

