/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.ExpressionNode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstNode
implements ExpressionNode {
    @Override
    public final Object getValue(Bindings bindings, ELContext context, Class<?> type) {
        Object value = this.eval(bindings, context);
        if (type != null) {
            value = bindings.convert(value, type);
        }
        return value;
    }

    public abstract void appendStructure(StringBuilder var1, Bindings var2);

    public abstract Object eval(Bindings var1, ELContext var2);

    @Override
    public final String getStructuralId(Bindings bindings) {
        StringBuilder builder = new StringBuilder();
        this.appendStructure(builder, bindings);
        return builder.toString();
    }

    private static Method findPublicAccessibleMethod(Method method) {
        if (method == null || !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (method.isAccessible() || Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class<?> cls : method.getDeclaringClass().getInterfaces()) {
            Method mth = null;
            try {
                mth = AstNode.findPublicAccessibleMethod(cls.getMethod(method.getName(), method.getParameterTypes()));
                if (mth == null) continue;
                return mth;
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        Class<?> cls = method.getDeclaringClass().getSuperclass();
        if (cls != null) {
            Method mth = null;
            try {
                mth = AstNode.findPublicAccessibleMethod(cls.getMethod(method.getName(), method.getParameterTypes()));
                if (mth != null) {
                    return mth;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Method findAccessibleMethod(Method method) {
        Method result = AstNode.findPublicAccessibleMethod(method);
        if (result == null && method != null && Modifier.isPublic(method.getModifiers())) {
            result = method;
            try {
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                result = null;
            }
        }
        return result;
    }
}

