/*
 * Decompiled with CFR 0.152.
 */
package de.nitri.slidingtoggleswitch;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import de.nitri.slidingtoggleswitch.R;

public class SlidingToggleSwitchView
extends FrameLayout
implements View.OnClickListener {
    private Button btnMovable;
    private Button btnLeft;
    private Button btnRight;
    private OnToggleListener listener;
    public static int LEFT_SELECTED = 0;
    public static int RIGHT_SELECTED = 1;
    private int POSITION = LEFT_SELECTED;
    private String leftButtonText;
    private String rightButtonText;
    private int textColor;
    private Drawable sliderBackground;
    private Drawable buttonBackground;

    public SlidingToggleSwitchView(Context context) {
        this(context, null);
    }

    public SlidingToggleSwitchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflater.inflate(R.layout.sliding_toggle_switch, (ViewGroup)this, true);
        this.btnMovable = (Button)v.findViewById(R.id.movable_button);
        this.btnLeft = (Button)v.findViewById(R.id.button_left);
        this.btnRight = (Button)v.findViewById(R.id.button_right);
        this.btnLeft.setOnClickListener((View.OnClickListener)this);
        this.btnRight.setOnClickListener((View.OnClickListener)this);
        this.listener = (OnToggleListener)context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlidingToggleSwitch, 0, 0);
        this.leftButtonText = a.getString(R.styleable.SlidingToggleSwitch_leftButtonText);
        this.rightButtonText = a.getString(R.styleable.SlidingToggleSwitch_rightButtonText);
        this.textColor = a.getColor(R.styleable.SlidingToggleSwitch_android_textColor, ContextCompat.getColor((Context)context, (int)17170451));
        this.sliderBackground = a.getDrawable(R.styleable.SlidingToggleSwitch_sliderBackground);
        this.buttonBackground = a.getDrawable(R.styleable.SlidingToggleSwitch_buttonBackground);
        a.recycle();
        if (!TextUtils.isEmpty((CharSequence)this.leftButtonText)) {
            this.btnLeft.setText((CharSequence)this.leftButtonText);
        }
        if (!TextUtils.isEmpty((CharSequence)this.rightButtonText)) {
            this.btnRight.setText((CharSequence)this.rightButtonText);
        }
        this.btnLeft.setTextColor(this.textColor);
        this.btnRight.setTextColor(this.textColor);
        if (this.sliderBackground == null) {
            this.setBackground(ContextCompat.getDrawable((Context)context, (int)R.drawable.toggle_frame));
        } else {
            this.setBackground(this.sliderBackground);
        }
        if (this.buttonBackground != null) {
            this.btnMovable.setBackground(this.buttonBackground);
        }
    }

    public SlidingToggleSwitchView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs);
    }

    public void onClick(View v) {
        if (this.POSITION == RIGHT_SELECTED) {
            this.POSITION = LEFT_SELECTED;
            this.listener.onToggle(LEFT_SELECTED);
            float destX = this.btnLeft.getX();
            ObjectAnimator shiftLeft = ObjectAnimator.ofFloat((Object)this.btnMovable, (String)"x", (float[])new float[]{destX});
            shiftLeft.start();
        } else {
            this.POSITION = RIGHT_SELECTED;
            this.listener.onToggle(RIGHT_SELECTED);
            float destX = this.btnRight.getX();
            ObjectAnimator shiftRight = ObjectAnimator.ofFloat((Object)this.btnMovable, (String)"x", (float[])new float[]{destX});
            shiftRight.start();
        }
    }

    public static interface OnToggleListener {
        public void onToggle(int var1);
    }
}

