/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.adapter.in.rest;

import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.FileDataDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.FileSizeDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.dto.PresignedUrlDto;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.FileDataMapper;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.FileSizeMapper;
import de.muenchen.refarch.integration.s3.adapter.in.rest.mapper.PresignedUrlMapper;
import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsInPort;
import de.muenchen.refarch.integration.s3.application.port.in.FileOperationsPresignedUrlInPort;
import de.muenchen.refarch.integration.s3.domain.exception.FileExistenceException;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;
import de.muenchen.refarch.integration.s3.domain.model.FileSize;
import de.muenchen.refarch.integration.s3.domain.model.PresignedUrl;
import de.muenchen.refarch.integration.s3.domain.validation.FolderInFilePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@Validated
@RestController
@Tag(name="FileAPI", description="API to interact with files")
@RequestMapping(value={"/file"})
public class FileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    private final FileOperationsPresignedUrlInPort fileOperationsPresignedUrl;
    private final FileOperationsInPort fileOperations;
    private final FileDataMapper fileMapper;
    private final PresignedUrlMapper presignedUrlMapper;
    private final FileSizeMapper fileSizeMapper;

    @GetMapping
    @Operation(description="Creates a presigned URL to fetch the file specified in the parameter from the S3 storage")
    public ResponseEntity<PresignedUrlDto> get(@RequestParam @NotEmpty @Size(max=1024) @FolderInFilePath @NotEmpty @Size(max=1024) @FolderInFilePath String pathToFile, @RequestParam @NotNull @Min(value=1L) @NotNull @Min(value=1L) Integer expiresInMinutes) {
        try {
            log.info("Received a request for S3 presigned url to download a file");
            PresignedUrl fileResponse = this.fileOperationsPresignedUrl.getFile(pathToFile, expiresInMinutes.intValue());
            PresignedUrlDto presignedUrlDto = this.presignedUrlMapper.model2Dto(fileResponse);
            return ResponseEntity.ok((Object)presignedUrlDto);
        }
        catch (FileSystemAccessException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
        catch (FileExistenceException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage(), (Throwable)exception);
        }
    }

    @GetMapping(value={"/size"})
    @Operation(description="Retrieves the size of the file specified in the parameter from the S3 storage")
    public ResponseEntity<FileSizeDto> getFileSize(@RequestParam @NotEmpty @Size(max=1024) @FolderInFilePath @NotEmpty @Size(max=1024) @FolderInFilePath String pathToFile) {
        try {
            log.info("Received a request for a file size");
            FileSize fileSize = this.fileOperations.getFileSize(pathToFile);
            FileSizeDto fileSizeDto = this.fileSizeMapper.model2dto(fileSize);
            return ResponseEntity.ok((Object)fileSizeDto);
        }
        catch (FileSystemAccessException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
        catch (FileExistenceException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage(), (Throwable)exception);
        }
    }

    @PostMapping
    @Operation(description="Creates a presigned URL to store the file specified in the parameter within the S3 storage")
    public ResponseEntity<PresignedUrlDto> save(@RequestBody @NotNull @Valid FileDataDto fileData) {
        try {
            log.info("Received a request for S3 presigned url to upload a new file");
            PresignedUrl presignedUrl = this.fileOperationsPresignedUrl.saveFile(this.fileMapper.dto2Model(fileData));
            PresignedUrlDto presignedUrlDto = this.presignedUrlMapper.model2Dto(presignedUrl);
            return ResponseEntity.ok((Object)presignedUrlDto);
        }
        catch (FileExistenceException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.CONFLICT, exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
    }

    @PutMapping
    @Operation(description="Creates a presigned URL to overwrite the file specified in the parameter within the S3 storage")
    public ResponseEntity<PresignedUrlDto> update(@RequestBody @NotNull @Valid FileDataDto fileData) {
        try {
            log.info("Received a request for S3 presigned url to upload a existing file");
            PresignedUrl presignedUrl = this.fileOperationsPresignedUrl.updateFile(this.fileMapper.dto2Model(fileData));
            PresignedUrlDto presignedUrlDto = this.presignedUrlMapper.model2Dto(presignedUrl);
            return ResponseEntity.ok((Object)presignedUrlDto);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
    }

    @DeleteMapping
    @Operation(description="Creates a presigned URL to delete the file specified in the parameter from the S3 storage")
    public ResponseEntity<PresignedUrlDto> deleteFile(@RequestParam @NotEmpty @Size(max=1024) @FolderInFilePath @NotEmpty @Size(max=1024) @FolderInFilePath String pathToFile, @RequestParam @NotNull @Min(value=1L) @NotNull @Min(value=1L) Integer expiresInMinutes) {
        try {
            log.info("Received a request for S3 presigned url to delete a file");
            PresignedUrl presignedUrl = this.fileOperationsPresignedUrl.deleteFile(pathToFile, expiresInMinutes.intValue());
            PresignedUrlDto presignedUrlDto = this.presignedUrlMapper.model2Dto(presignedUrl);
            return ResponseEntity.ok((Object)presignedUrlDto);
        }
        catch (FileSystemAccessException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, exception.getMessage(), (Throwable)exception);
        }
        catch (FileExistenceException exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, exception.getMessage(), (Throwable)exception);
        }
        catch (Exception exception) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exception.getMessage(), (Throwable)exception);
        }
    }

    @Generated
    public FileController(FileOperationsPresignedUrlInPort fileOperationsPresignedUrl, FileOperationsInPort fileOperations, FileDataMapper fileMapper, PresignedUrlMapper presignedUrlMapper, FileSizeMapper fileSizeMapper) {
        this.fileOperationsPresignedUrl = fileOperationsPresignedUrl;
        this.fileOperations = fileOperations;
        this.fileMapper = fileMapper;
        this.presignedUrlMapper = presignedUrlMapper;
        this.fileSizeMapper = fileSizeMapper;
    }
}

