/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository;

import de.muenchen.refarch.integration.s3.client.api.FolderApiApi;
import de.muenchen.refarch.integration.s3.client.domain.model.FileMetadata;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.model.FileSizesInFolderDto;
import de.muenchen.refarch.integration.s3.client.model.FilesInFolderDto;
import de.muenchen.refarch.integration.s3.client.model.FilesMetadataInFolderDto;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFolderRepository;
import de.muenchen.refarch.integration.s3.client.repository.mapper.FileMetadataMapper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import reactor.core.publisher.Mono;

public class DocumentStorageFolderRestRepository
implements DocumentStorageFolderRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentStorageFolderRestRepository.class);
    private final FolderApiApi folderApi;
    private final FileMetadataMapper fileMetadataMapper;

    public void deleteFolder(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            this.folderApi.deleteFolder(pathToFolder).block();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to delete a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to delete a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to delete a folder failed.";
            log.error("The request to delete a folder failed.");
            throw new DocumentStorageException("The request to delete a folder failed.", (Exception)((Object)exception));
        }
    }

    public Set<String> getAllFilesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            Mono<FilesInFolderDto> filesInFolderDto = this.folderApi.getAllFilesInFolderRecursively(pathToFolder);
            return ((FilesInFolderDto)filesInFolderDto.block()).getPathToFiles();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to get all files within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to get all files within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to get all files within a folder failed.";
            log.error("The request to get all files within a folder failed.");
            throw new DocumentStorageException("The request to get all files within a folder failed.", (Exception)((Object)exception));
        }
    }

    public List<FileMetadata> getMetadataOfAllFilesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            Mono<FilesMetadataInFolderDto> filesMetadateInFolder = this.folderApi.getMetadataOfAllFilesInFolderRecursively(pathToFolder);
            return this.fileMetadataMapper.dto2Model(((FilesMetadataInFolderDto)filesMetadateInFolder.block()).getFiles());
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to get the metadata of all files within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to get the metadata of all files within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to get the metadata of all files within a folder failed.";
            log.error("The request to get the metadata of all files within a folder failed.");
            throw new DocumentStorageException("The request to get the metadata of all files within a folder failed.", (Exception)((Object)exception));
        }
    }

    public Map<String, Long> getAllFileSizesInFolderRecursively(String pathToFolder) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            Mono<FileSizesInFolderDto> fileSizesInFolderDtoMono = this.folderApi.getAllFileSizesInFolderRecursively(pathToFolder);
            return ((FileSizesInFolderDto)fileSizesInFolderDtoMono.block()).getFileSizes();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to get all file sizes within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to get all file sizes within a folder failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to get all file sizes within a folder failed.";
            log.error("The request to get all file sizes within a folder failed.");
            throw new DocumentStorageException("The request to get all file sizes within a folder failed.", (Exception)((Object)exception));
        }
    }

    @Generated
    public DocumentStorageFolderRestRepository(FolderApiApi folderApi, FileMetadataMapper fileMetadataMapper) {
        this.folderApi = folderApi;
        this.fileMetadataMapper = fileMetadataMapper;
    }
}

