/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository;

import de.muenchen.refarch.integration.s3.client.api.FileApiApi;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.model.FileSizeDto;
import de.muenchen.refarch.integration.s3.client.repository.DocumentStorageFileRepository;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import de.muenchen.refarch.integration.s3.client.repository.transfer.S3FileTransferRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;

public class DocumentStorageFileRestRepository
extends DocumentStorageFileRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentStorageFileRestRepository.class);
    private final FileApiApi fileApi;

    public DocumentStorageFileRestRepository(PresignedUrlRepository presignedUrlRepository, S3FileTransferRepository s3FileTransferRepository, FileApiApi fileApi) {
        super(presignedUrlRepository, s3FileTransferRepository);
        this.fileApi = fileApi;
    }

    public Long getFileSize(String pathToFile) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            return ((FileSizeDto)this.fileApi.getFileSize(pathToFile).block()).getFileSize();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format("The request to get file size failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format("The request to get file size failed %s.", exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (RestClientException exception) {
            String message = "The request to get a file size failed.";
            log.error("The request to get a file size failed.");
            throw new DocumentStorageException("The request to get a file size failed.", (Exception)((Object)exception));
        }
    }
}

