/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.api;

import de.muenchen.refarch.integration.s3.client.ApiClient;
import de.muenchen.refarch.integration.s3.client.model.FileSizesInFolderDto;
import de.muenchen.refarch.integration.s3.client.model.FilesInFolderDto;
import de.muenchen.refarch.integration.s3.client.model.FilesMetadataInFolderDto;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class FolderApiApi {
    private ApiClient apiClient;

    public FolderApiApi() {
        this(new ApiClient());
    }

    public FolderApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec deleteFolderRequestCreation(@Nonnull String pathToFolder) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFolder == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFolder' when calling deleteFolder", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFolder", pathToFolder));
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.apiClient.invokeAPI("/folder", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> deleteFolder(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.deleteFolderRequestCreation(pathToFolder).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> deleteFolderWithHttpInfo(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(this){};
        return this.deleteFolderRequestCreation(pathToFolder).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteFolderWithResponseSpec(@Nonnull String pathToFolder) throws WebClientResponseException {
        return this.deleteFolderRequestCreation(pathToFolder);
    }

    private WebClient.ResponseSpec getAllFileSizesInFolderRecursivelyRequestCreation(@Nonnull String pathToFolder) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFolder == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFolder' when calling getAllFileSizesInFolderRecursively", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFolder", pathToFolder));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<FileSizesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FileSizesInFolderDto>(this){};
        return this.apiClient.invokeAPI("/folder/size", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FileSizesInFolderDto> getAllFileSizesInFolderRecursively(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FileSizesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FileSizesInFolderDto>(this){};
        return this.getAllFileSizesInFolderRecursivelyRequestCreation(pathToFolder).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FileSizesInFolderDto>> getAllFileSizesInFolderRecursivelyWithHttpInfo(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FileSizesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FileSizesInFolderDto>(this){};
        return this.getAllFileSizesInFolderRecursivelyRequestCreation(pathToFolder).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAllFileSizesInFolderRecursivelyWithResponseSpec(@Nonnull String pathToFolder) throws WebClientResponseException {
        return this.getAllFileSizesInFolderRecursivelyRequestCreation(pathToFolder);
    }

    private WebClient.ResponseSpec getAllFilesInFolderRecursivelyRequestCreation(@Nonnull String pathToFolder) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFolder == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFolder' when calling getAllFilesInFolderRecursively", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFolder", pathToFolder));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<FilesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesInFolderDto>(this){};
        return this.apiClient.invokeAPI("/folder", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FilesInFolderDto> getAllFilesInFolderRecursively(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FilesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesInFolderDto>(this){};
        return this.getAllFilesInFolderRecursivelyRequestCreation(pathToFolder).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FilesInFolderDto>> getAllFilesInFolderRecursivelyWithHttpInfo(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FilesInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesInFolderDto>(this){};
        return this.getAllFilesInFolderRecursivelyRequestCreation(pathToFolder).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAllFilesInFolderRecursivelyWithResponseSpec(@Nonnull String pathToFolder) throws WebClientResponseException {
        return this.getAllFilesInFolderRecursivelyRequestCreation(pathToFolder);
    }

    private WebClient.ResponseSpec getMetadataOfAllFilesInFolderRecursivelyRequestCreation(@Nonnull String pathToFolder) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFolder == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFolder' when calling getMetadataOfAllFilesInFolderRecursively", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFolder", pathToFolder));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<FilesMetadataInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesMetadataInFolderDto>(this){};
        return this.apiClient.invokeAPI("/folder/metadata", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FilesMetadataInFolderDto> getMetadataOfAllFilesInFolderRecursively(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FilesMetadataInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesMetadataInFolderDto>(this){};
        return this.getMetadataOfAllFilesInFolderRecursivelyRequestCreation(pathToFolder).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FilesMetadataInFolderDto>> getMetadataOfAllFilesInFolderRecursivelyWithHttpInfo(@Nonnull String pathToFolder) throws WebClientResponseException {
        ParameterizedTypeReference<FilesMetadataInFolderDto> localVarReturnType = new ParameterizedTypeReference<FilesMetadataInFolderDto>(this){};
        return this.getMetadataOfAllFilesInFolderRecursivelyRequestCreation(pathToFolder).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getMetadataOfAllFilesInFolderRecursivelyWithResponseSpec(@Nonnull String pathToFolder) throws WebClientResponseException {
        return this.getMetadataOfAllFilesInFolderRecursivelyRequestCreation(pathToFolder);
    }
}

