/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.api;

import de.muenchen.refarch.integration.s3.client.ApiClient;
import de.muenchen.refarch.integration.s3.client.model.FileDataDto;
import de.muenchen.refarch.integration.s3.client.model.FileSizeDto;
import de.muenchen.refarch.integration.s3.client.model.PresignedUrlDto;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class FileApiApi {
    private ApiClient apiClient;

    public FileApiApi() {
        this(new ApiClient());
    }

    public FileApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec deleteFileRequestCreation(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFile == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFile' when calling deleteFile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (expiresInMinutes == null) {
            throw new WebClientResponseException("Missing the required parameter 'expiresInMinutes' when calling deleteFile", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFile", pathToFile));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expiresInMinutes", expiresInMinutes));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.apiClient.invokeAPI("/file", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PresignedUrlDto> deleteFile(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.deleteFileRequestCreation(pathToFile, expiresInMinutes).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PresignedUrlDto>> deleteFileWithHttpInfo(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.deleteFileRequestCreation(pathToFile, expiresInMinutes).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deleteFileWithResponseSpec(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        return this.deleteFileRequestCreation(pathToFile, expiresInMinutes);
    }

    private WebClient.ResponseSpec getRequestCreation(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFile == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFile' when calling get", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (expiresInMinutes == null) {
            throw new WebClientResponseException("Missing the required parameter 'expiresInMinutes' when calling get", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFile", pathToFile));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "expiresInMinutes", expiresInMinutes));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.apiClient.invokeAPI("/file", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PresignedUrlDto> get(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.getRequestCreation(pathToFile, expiresInMinutes).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PresignedUrlDto>> getWithHttpInfo(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.getRequestCreation(pathToFile, expiresInMinutes).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getWithResponseSpec(@Nonnull String pathToFile, @Nonnull Integer expiresInMinutes) throws WebClientResponseException {
        return this.getRequestCreation(pathToFile, expiresInMinutes);
    }

    private WebClient.ResponseSpec getFileSizeRequestCreation(@Nonnull String pathToFile) throws WebClientResponseException {
        Object postBody = null;
        if (pathToFile == null) {
            throw new WebClientResponseException("Missing the required parameter 'pathToFile' when calling getFileSize", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "pathToFile", pathToFile));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<FileSizeDto> localVarReturnType = new ParameterizedTypeReference<FileSizeDto>(this){};
        return this.apiClient.invokeAPI("/file/size", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<FileSizeDto> getFileSize(@Nonnull String pathToFile) throws WebClientResponseException {
        ParameterizedTypeReference<FileSizeDto> localVarReturnType = new ParameterizedTypeReference<FileSizeDto>(this){};
        return this.getFileSizeRequestCreation(pathToFile).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<FileSizeDto>> getFileSizeWithHttpInfo(@Nonnull String pathToFile) throws WebClientResponseException {
        ParameterizedTypeReference<FileSizeDto> localVarReturnType = new ParameterizedTypeReference<FileSizeDto>(this){};
        return this.getFileSizeRequestCreation(pathToFile).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getFileSizeWithResponseSpec(@Nonnull String pathToFile) throws WebClientResponseException {
        return this.getFileSizeRequestCreation(pathToFile);
    }

    private WebClient.ResponseSpec saveRequestCreation(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        FileDataDto postBody = fileDataDto;
        if (fileDataDto == null) {
            throw new WebClientResponseException("Missing the required parameter 'fileDataDto' when calling save", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.apiClient.invokeAPI("/file", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PresignedUrlDto> save(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.saveRequestCreation(fileDataDto).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PresignedUrlDto>> saveWithHttpInfo(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.saveRequestCreation(fileDataDto).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec saveWithResponseSpec(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        return this.saveRequestCreation(fileDataDto);
    }

    private WebClient.ResponseSpec updateRequestCreation(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        FileDataDto postBody = fileDataDto;
        if (fileDataDto == null) {
            throw new WebClientResponseException("Missing the required parameter 'fileDataDto' when calling update", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.apiClient.invokeAPI("/file", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PresignedUrlDto> update(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.updateRequestCreation(fileDataDto).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PresignedUrlDto>> updateWithHttpInfo(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        ParameterizedTypeReference<PresignedUrlDto> localVarReturnType = new ParameterizedTypeReference<PresignedUrlDto>(this){};
        return this.updateRequestCreation(fileDataDto).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateWithResponseSpec(@Nonnull FileDataDto fileDataDto) throws WebClientResponseException {
        return this.updateRequestCreation(fileDataDto);
    }
}

