/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.application.usecase;

import de.muenchen.refarch.integration.s3.application.port.in.FolderOperationsInPort;
import de.muenchen.refarch.integration.s3.application.port.out.S3OutPort;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;
import de.muenchen.refarch.integration.s3.domain.model.FileMetadata;
import de.muenchen.refarch.integration.s3.domain.model.FileSizesInFolder;
import de.muenchen.refarch.integration.s3.domain.model.FilesInFolder;
import de.muenchen.refarch.integration.s3.domain.model.FilesMetadataInFolder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FolderOperationsUseCase
implements FolderOperationsInPort {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FolderOperationsUseCase.class);
    private final S3OutPort s3OutPort;

    public static String addPathSeparatorToTheEnd(String pathToFolder) {
        Object correctedPathToFolder = pathToFolder;
        if (StringUtils.isNotEmpty((CharSequence)pathToFolder) && !StringUtils.endsWith((CharSequence)pathToFolder, (CharSequence)"/")) {
            correctedPathToFolder = (String)correctedPathToFolder + "/";
        }
        return correctedPathToFolder;
    }

    @Override
    public void deleteFolder(@NotNull String pathToFolder) throws FileSystemAccessException {
        String pathToFolderWithSeparatorAtTheEnd = FolderOperationsUseCase.addPathSeparatorToTheEnd(pathToFolder);
        Set<String> filePathsInFolder = this.s3OutPort.getFilePathsFromFolder(pathToFolderWithSeparatorAtTheEnd);
        if (filePathsInFolder.isEmpty()) {
            log.info("Folder is empty in s3");
        } else {
            log.info("Deleting {} files in folder {}", (Object)filePathsInFolder.size(), (Object)pathToFolderWithSeparatorAtTheEnd);
            for (String pathToFile : filePathsInFolder) {
                this.s3OutPort.deleteFile(pathToFile);
            }
        }
    }

    @Override
    @NotNull
    public FilesInFolder getAllFilesInFolderRecursively(@NotNull String pathToFolder) throws FileSystemAccessException {
        String pathToFolderWithSeparatorAtTheEnd = FolderOperationsUseCase.addPathSeparatorToTheEnd(pathToFolder);
        Set<String> filePathsInFolder = this.s3OutPort.getFilePathsFromFolder(pathToFolderWithSeparatorAtTheEnd);
        return new FilesInFolder(filePathsInFolder);
    }

    @Override
    @NotNull
    public FilesMetadataInFolder getMetadataOfAllFilesInFolderRecursively(@NotNull String pathToFolder) throws FileSystemAccessException {
        String pathToFolderWithSeparatorAtTheEnd = FolderOperationsUseCase.addPathSeparatorToTheEnd(pathToFolder);
        List<FileMetadata> filePathsInFolder = this.s3OutPort.getMetadataOfFilesFromFolder(pathToFolderWithSeparatorAtTheEnd);
        return new FilesMetadataInFolder(filePathsInFolder);
    }

    @Override
    public FileSizesInFolder getAllFileSizesInFolderRecursively(@NotNull String pathToFolder) throws FileSystemAccessException {
        String pathToFolderWithSeparatorAtTheEnd = FolderOperationsUseCase.addPathSeparatorToTheEnd(pathToFolder);
        Map<String, Long> mapFilePathsToSize = this.s3OutPort.getFileSizesFromFolder(pathToFolderWithSeparatorAtTheEnd);
        return new FileSizesInFolder(mapFilePathsToSize);
    }

    @Generated
    public FolderOperationsUseCase(S3OutPort s3OutPort) {
        this.s3OutPort = s3OutPort;
    }
}

