/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.adapter.out.s3;

import de.muenchen.refarch.integration.s3.application.port.out.S3OutPort;
import de.muenchen.refarch.integration.s3.domain.exception.FileSystemAccessException;
import de.muenchen.refarch.integration.s3.domain.model.FileMetadata;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.MinioException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Item;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Adapter
implements S3OutPort {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3Adapter.class);
    private static final String RESPONSE_CODE_NO_SUCH_KEY = "NoSuchKey";
    private final String bucketName;
    private final MinioClient client;

    public S3Adapter(String bucketName, MinioClient client) {
        this.bucketName = bucketName;
        this.client = client;
    }

    @PreDestroy
    public void cleanup() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public boolean fileExists(String path) throws FileSystemAccessException {
        try {
            this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(path)).build());
        }
        catch (ErrorResponseException errorResponseException) {
            if (RESPONSE_CODE_NO_SUCH_KEY.equals(errorResponseException.errorResponse().code())) {
                return false;
            }
            throw new FileSystemAccessException(errorResponseException.errorResponse().code(), (Exception)((Object)errorResponseException));
        }
        catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to request metadata for file %s.", path);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
        return true;
    }

    @Override
    public Set<String> getFilePathsFromFolder(String folder) throws FileSystemAccessException {
        try {
            ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix(folder).recursive(true).build();
            List resultItemList = IteratorUtils.toList(this.client.listObjects(listObjectsArgs).iterator());
            HashSet<String> filepathesFromFolder = new HashSet<String>();
            for (Result resultItem : resultItemList) {
                filepathesFromFolder.add(((Item)resultItem.get()).objectName());
            }
            return filepathesFromFolder;
        }
        catch (MinioException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to extract file paths from folder %s.", folder);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    @Override
    public List<FileMetadata> getMetadataOfFilesFromFolder(String folder) throws FileSystemAccessException {
        try {
            ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix(folder).recursive(true).build();
            List resultItemList = IteratorUtils.toList(this.client.listObjects(listObjectsArgs).iterator());
            ArrayList<FileMetadata> fileInformationsFromFolder = new ArrayList<FileMetadata>();
            for (Result resultItem : resultItemList) {
                FileMetadata fileInformation = new FileMetadata(((Item)resultItem.get()).objectName(), ((Item)resultItem.get()).size(), StringUtils.strip((String)((Item)resultItem.get()).etag(), (String)"\""), ((Item)resultItem.get()).lastModified().toLocalDateTime());
                fileInformationsFromFolder.add(fileInformation);
            }
            return fileInformationsFromFolder;
        }
        catch (MinioException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to extract the metadata of the files from folder %s.", folder);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    @Override
    public Map<String, Long> getFileSizesFromFolder(String folder) throws FileSystemAccessException {
        try {
            ListObjectsArgs listObjectsArgs = (ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).prefix(folder).recursive(true).build();
            List resultItemList = IteratorUtils.toList(this.client.listObjects(listObjectsArgs).iterator());
            HashMap<String, Long> filePathsFromFolder = new HashMap<String, Long>();
            for (Result resultItem : resultItemList) {
                filePathsFromFolder.put(((Item)resultItem.get()).objectName(), ((Item)resultItem.get()).size());
            }
            return filePathsFromFolder;
        }
        catch (MinioException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to extract file paths from folder %s.", folder);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    @Override
    public long getFileSize(String pathToFile) throws FileSystemAccessException {
        try {
            return this.client.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(pathToFile)).build()).size();
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to request size of file %s.", pathToFile);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    @Override
    public void deleteFile(String pathToFile) throws FileSystemAccessException {
        try {
            RemoveObjectArgs removeObjectArgs = (RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(pathToFile)).build();
            this.client.removeObject(removeObjectArgs);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to delete file %s.", pathToFile);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    @Override
    public String getPresignedUrl(String pathToFile, Method action, int expiresInMinutes) throws FileSystemAccessException {
        try {
            GetPresignedObjectUrlArgs presignedUrlArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(action).bucket(this.bucketName)).object(pathToFile)).expiry(expiresInMinutes, TimeUnit.MINUTES).build();
            return this.client.getPresignedObjectUrl(presignedUrlArgs);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = String.format("Failed to create presigned url for file %s. in mode %s", pathToFile, action);
            log.error(message, exception);
            throw new FileSystemAccessException(message, (Exception)exception);
        }
    }

    public void testConnection() throws FileSystemAccessException {
        try {
            boolean bucketExists = this.client.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.bucketName)).build());
            if (!bucketExists) {
                String message = "S3 bucket does not exist.";
                log.error("S3 bucket does not exist.");
                throw new FileSystemAccessException("S3 bucket does not exist.");
            }
        }
        catch (MinioException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException exception) {
            String message = "S3 initialization failed.";
            log.error("S3 initialization failed.", exception);
            throw new FileSystemAccessException("S3 initialization failed.", (Exception)exception);
        }
    }
}

