/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository.transfer;

import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Repository;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;

@Repository
public class S3FileTransferRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3FileTransferRepository.class);
    private static final String REQUEST_FAILED_WITH_STATUS_CODE = "The presigned url request failed with http status %s.";
    private static final String REQUEST_FAILED = "The presigned url request failed.";
    private final RestTemplate restTemplate = new RestTemplate();

    public byte[] getFile(String presignedUrl) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        return this.executeWithErrorHandling(() -> {
            HttpHeaders headers = new HttpHeaders();
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(URI.create(presignedUrl), HttpMethod.GET, httpEntity, byte[].class);
            return (byte[])responseEntity.getBody();
        });
    }

    public InputStream getFileInputStream(String presignedUrl) throws DocumentStorageException {
        try {
            UrlResource urlResource = new UrlResource(presignedUrl);
            return urlResource.getInputStream();
        }
        catch (IOException exception) {
            String message = REQUEST_FAILED;
            log.error(REQUEST_FAILED);
            throw new DocumentStorageException(REQUEST_FAILED, exception);
        }
    }

    public void saveFile(String presignedUrl, byte[] file) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        this.executeWithErrorHandling(() -> {
            HttpHeaders headers = new HttpHeaders();
            HttpEntity fileHttpEntity = new HttpEntity((Object)file, (MultiValueMap)headers);
            this.restTemplate.exchange(URI.create(presignedUrl), HttpMethod.PUT, fileHttpEntity, Void.class);
            return null;
        });
    }

    public void saveFileInputStream(String presignedUrl, InputStream file) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        this.executeWithErrorHandling(() -> {
            HttpHeaders headers = new HttpHeaders();
            HttpEntity fileHttpEntity = new HttpEntity((Object)new InputStreamResource(file), (MultiValueMap)headers);
            this.restTemplate.exchange(URI.create(presignedUrl), HttpMethod.PUT, fileHttpEntity, Void.class);
            return null;
        });
    }

    public void updateFile(String presignedUrl, byte[] file) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        this.saveFile(presignedUrl, file);
    }

    public void updateFileInputStream(String presignedUrl, InputStream file) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        this.saveFileInputStream(presignedUrl, file);
    }

    public void deleteFile(String presignedUrl) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        this.executeWithErrorHandling(() -> {
            HttpHeaders headers = new HttpHeaders();
            HttpEntity fileHttpEntity = new HttpEntity((MultiValueMap)headers);
            this.restTemplate.exchange(URI.create(presignedUrl), HttpMethod.DELETE, fileHttpEntity, Void.class);
            return null;
        });
    }

    private <T> T executeWithErrorHandling(Callable<T> callable) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException {
        try {
            return callable.call();
        }
        catch (HttpClientErrorException exception) {
            String message = String.format(REQUEST_FAILED_WITH_STATUS_CODE, exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageClientErrorException(message, (Exception)((Object)exception));
        }
        catch (HttpServerErrorException exception) {
            String message = String.format(REQUEST_FAILED_WITH_STATUS_CODE, exception.getStatusCode());
            log.error(message);
            throw new DocumentStorageServerErrorException(message, (Exception)((Object)exception));
        }
        catch (Exception exception) {
            String message = REQUEST_FAILED;
            log.error(REQUEST_FAILED);
            throw new DocumentStorageException(REQUEST_FAILED, exception);
        }
    }

    @Generated
    public S3FileTransferRepository() {
    }
}

