/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.refarch.integration.s3.client.repository;

import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageClientErrorException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageException;
import de.muenchen.refarch.integration.s3.client.exception.DocumentStorageServerErrorException;
import de.muenchen.refarch.integration.s3.client.repository.presignedurl.PresignedUrlRepository;
import de.muenchen.refarch.integration.s3.client.repository.transfer.S3FileTransferRepository;
import java.io.InputStream;
import lombok.Generated;

public abstract class DocumentStorageFileRepository {
    protected final PresignedUrlRepository presignedUrlRepository;
    protected final S3FileTransferRepository s3FileTransferRepository;

    public byte[] getFile(String pathToFile, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlGetFile(pathToFile, expireInMinutes);
        return this.s3FileTransferRepository.getFile(presignedUrl);
    }

    public abstract Long getFileSize(String var1) throws DocumentStorageClientErrorException, DocumentStorageServerErrorException, DocumentStorageException;

    public InputStream getFileInputStream(String pathToFile, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlGetFile(pathToFile, expireInMinutes);
        return this.s3FileTransferRepository.getFileInputStream(presignedUrl);
    }

    public void saveFile(String pathToFile, byte[] file, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlSaveFile(pathToFile, expireInMinutes);
        this.s3FileTransferRepository.saveFile(presignedUrl, file);
    }

    public void saveFileInputStream(String pathToFile, InputStream file, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlSaveFile(pathToFile, expireInMinutes);
        this.s3FileTransferRepository.saveFileInputStream(presignedUrl, file);
    }

    public void updateFile(String pathToFile, byte[] file, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlUpdateFile(pathToFile, expireInMinutes);
        this.s3FileTransferRepository.updateFile(presignedUrl, file);
    }

    public void updateFileInputStream(String pathToFile, InputStream file, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlUpdateFile(pathToFile, expireInMinutes);
        this.s3FileTransferRepository.updateFileInputStream(presignedUrl, file);
    }

    public void deleteFile(String pathToFile, int expireInMinutes) throws DocumentStorageException, DocumentStorageClientErrorException, DocumentStorageServerErrorException {
        String presignedUrl = this.presignedUrlRepository.getPresignedUrlDeleteFile(pathToFile, expireInMinutes);
        this.s3FileTransferRepository.deleteFile(presignedUrl);
    }

    @Generated
    public DocumentStorageFileRepository(PresignedUrlRepository presignedUrlRepository, S3FileTransferRepository s3FileTransferRepository) {
        this.presignedUrlRepository = presignedUrlRepository;
        this.s3FileTransferRepository = s3FileTransferRepository;
    }
}

