/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.wahllokalsystem.wls.common.testing;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtils {
    public static final String TESTUSER_DEFAULT = "TESTUSER";
    public static final String TESTUSER_PASSWORD_DEFAULT = "TESTUSER_PASSWORD";

    public static void runAs(String username, String password, String ... authorities) {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)AuthorityUtils.createAuthorityList((String[])authorities)));
    }

    public static void runWith(String ... authorities) {
        SecurityUtils.runAs(TESTUSER_DEFAULT, TESTUSER_PASSWORD_DEFAULT, authorities);
    }

    public static Stream<Arguments> buildArgumentsForMissingAuthoritiesVariations(String[] allRequiredAuthorities) {
        return Arrays.stream(allRequiredAuthorities).map(authorityToRemove -> Arguments.of((Object[])new Object[]{Arrays.stream(allRequiredAuthorities).filter(authority -> !authority.equals(authorityToRemove)).toArray(String[]::new), authorityToRemove}));
    }
}

