/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.ad2image.starter.spring;

import de.muenchen.oss.ad2image.starter.core.Ad2ImageConfigurationProperties;
import de.muenchen.oss.ad2image.starter.core.ImageSize;
import de.muenchen.oss.ad2image.starter.core.Mode;
import de.muenchen.oss.ad2image.starter.spring.AvatarService;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Tag(name="avatar", description="the avatar API")
@OpenAPIDefinition(info=@Info(title="ad2image API", description="easy avatars powered by AD / Exchange & Identicons", version="v1", contact=@Contact(name="Munich Open Source", url="https://opensource.muenchen.de/", email="opensource@muenchen.de")), externalDocs=@ExternalDocumentation(description="More documentation and examples", url="https://github.com/it-at-m/ad2image?tab=readme-ov-file#documentation"))
public class AvatarController {
    private static final Logger log = LoggerFactory.getLogger(AvatarController.class);
    private final AvatarService avatarService;
    private final Ad2ImageConfigurationProperties confProps;

    public AvatarController(AvatarService avatarService, Ad2ImageConfigurationProperties confProps) {
        this.avatarService = avatarService;
        this.confProps = confProps;
    }

    @Operation(summary="Retrieve a users avatar image", description="Retrieve a users avatar image")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful operation", content={@Content(mediaType="image/jpeg"), @Content(mediaType="image/png")}), @ApiResponse(responseCode="404", description="User not found or user has no avatar image", content={@Content(schema=@Schema(implementation=Void.class))})})
    @GetMapping(value={"avatar"}, produces={"image/jpeg", "image/png"})
    public ResponseEntity<byte[]> avatar(@Parameter(description="uid of the user", example="john.doe", required=true) @RequestParam(required=true) String uid, @Parameter(description="retrieval mode", example="fallbackGeneric") @RequestParam(name="m", required=false) String mode, @Parameter(description="image size", schema=@Schema(defaultValue="64", example="64", allowableValues={"64", "96", "120", "240", "360", "432", "504", "648"})) @RequestParam(name="size", required=false, defaultValue="64") String requestedSize) {
        log.info("Incoming avatar request for uid='{}', m='{}', size='{}'", new Object[]{uid, mode, requestedSize});
        ImageSize resolvedSize = this.resolveSize(requestedSize);
        Mode resolvedMode = this.resolveMode(mode);
        byte[] jpegThumbnail = this.avatarService.get(uid, resolvedMode, resolvedSize);
        if (jpegThumbnail != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "image/jpeg");
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.DAYS))).headers(headers)).body((Object)jpegThumbnail);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private Mode resolveMode(String mode) {
        Mode resolvedMode = this.confProps.getDefaultMode();
        EnumSet<Mode> allPossibleModes = EnumSet.allOf(Mode.class);
        for (Mode possibleMode : allPossibleModes) {
            if (!possibleMode.getParameterValue().equalsIgnoreCase(mode)) continue;
            return possibleMode;
        }
        return resolvedMode;
    }

    private ImageSize resolveSize(String requestedSize) {
        ImageSize resolvedSize = ImageSize.getAdDefaultImageSize();
        try {
            Integer requestedSizeInteger = Integer.valueOf(requestedSize);
            EnumSet<ImageSize> allPossibleSizes = EnumSet.allOf(ImageSize.class);
            for (ImageSize imageSize : allPossibleSizes) {
                if (imageSize.getSizePixels() != requestedSizeInteger.intValue()) continue;
                return imageSize;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Could not resolve size parameter value '{}' to a valid ImageSize enum constant, using default size {}.", (Object)requestedSize, (Object)resolvedSize);
        }
        return resolvedSize;
    }
}

