/*
 * Decompiled with CFR 0.152.
 */
package de.muenchen.oss.ad2image.starter.spring;

import de.muenchen.oss.ad2image.starter.core.ImageSize;
import de.muenchen.oss.ad2image.starter.spring.AvatarService;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AvatarController {
    private static final Logger log = LoggerFactory.getLogger(AvatarController.class);
    private final AvatarService avatarService;

    public AvatarController(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @GetMapping(value={"avatar"}, produces={"image/jpeg", "image/png"})
    public ResponseEntity<byte[]> avatar(@RequestParam(required=true) String uid, @RequestParam(name="m", required=false, defaultValue="identicon") String mode, @RequestParam(name="size", required=false, defaultValue="64") String requestedSize) {
        log.info("Incoming avatar request for uid='{}', m='{}', size='{}'", new Object[]{uid, mode, requestedSize});
        ImageSize resolvedSize = this.resolveSize(requestedSize);
        byte[] jpegThumbnail = this.avatarService.get(uid, mode, resolvedSize);
        if (jpegThumbnail != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "image/jpeg");
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.DAYS))).headers(headers)).body((Object)jpegThumbnail);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private ImageSize resolveSize(String requestedSize) {
        ImageSize resolvedSize = ImageSize.getAdDefaultImageSize();
        try {
            Integer requestedSizeInteger = Integer.valueOf(requestedSize);
            EnumSet<ImageSize> allPossibleSizes = EnumSet.allOf(ImageSize.class);
            for (ImageSize imageSize : allPossibleSizes) {
                if (imageSize.getSizePixels() != requestedSizeInteger.intValue()) continue;
                return imageSize;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Could not resolve size parameter value '{}' to a valid ImageSize enum constant, using default size {}.", (Object)requestedSize, (Object)resolvedSize);
        }
        return resolvedSize;
    }
}

