/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.junitsupport;

import de.mklinger.commons.junitsupport.RuntimeIgnore;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.internal.ExactComparisonCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Not a test")
public class BeanTestBase<T> {
    protected static final ConstructorParameters DEFAULT_CONSTRUCTOR_PARAMETERS = new ConstructorParameters(new Class[0], new String[0]);
    private static final Logger LOG = LoggerFactory.getLogger(BeanTestBase.class);
    private static final String SETTER_PREFIX = "set";
    private static final int TIME_MULT = 100000;
    private static final float DELTA = 1.0E-13f;
    private static final int CREATED_ARRAY_LENGTH = 5;
    private static final String CLASS_AND_FIELD_SEPERATOR = "#";
    private final Class<T> beanClass;
    private long nextValue = 1L;
    private Map<Class<?>[], Object[]> allConstructorPropertyValues;

    public BeanTestBase(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    private static void addAllFields(Class<?> clazz, List<Field> allFields) {
        allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            BeanTestBase.addAllFields(superclass, allFields);
        }
    }

    private Field[] getAllFields() {
        ArrayList<Field> allFields = new ArrayList<Field>();
        BeanTestBase.addAllFields(this.beanClass, allFields);
        return allFields.toArray(new Field[allFields.size()]);
    }

    private static void addAllSetters(Class<?> clazz, List<Method> allSetters) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!method.getName().startsWith(SETTER_PREFIX) || method.getParameterTypes().length != 1) continue;
            allSetters.add(method);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            BeanTestBase.addAllSetters(superclass, allSetters);
        }
    }

    private Method[] getAllSetters() {
        ArrayList<Method> allSetters = new ArrayList<Method>();
        BeanTestBase.addAllSetters(this.beanClass, allSetters);
        return allSetters.toArray(new Method[allSetters.size()]);
    }

    protected Collection<String> getBeanPropertyNames() {
        Method[] allSetters;
        Field[] allFields;
        HashSet<String> beanPropertyNames = new HashSet<String>();
        for (Field field : allFields = this.getAllFields()) {
            if (!this.isBeanFieldCandidate(field)) continue;
            beanPropertyNames.add(field.getName());
        }
        for (Method setter : allSetters = this.getAllSetters()) {
            String propertyName = setter.getName().substring(SETTER_PREFIX.length());
            propertyName = propertyName.length() == 1 ? propertyName.toLowerCase() : propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
            Method getter = this.getGetter(propertyName);
            if (getter == null || this.isIgnoreProperty(propertyName)) continue;
            beanPropertyNames.add(propertyName);
        }
        return beanPropertyNames;
    }

    protected Collection<Field> getBeanFields() {
        Collection<String> beanPropertyNames = this.getBeanPropertyNames();
        ArrayList<Field> beanFields = new ArrayList<Field>(beanPropertyNames.size());
        for (String propertyName : beanPropertyNames) {
            try {
                Field field = this.getDeclaredField(propertyName);
                field.setAccessible(true);
                beanFields.add(field);
            }
            catch (NoSuchFieldException e) {
                LOG.debug("getBeanFields()", (Throwable)e);
            }
        }
        return beanFields;
    }

    private Field getDeclaredField(String propertyName) throws NoSuchFieldException {
        return this.getDeclaredFieldRecursive(this.beanClass, propertyName);
    }

    private Field getDeclaredFieldRecursive(Class<?> startClass, String propertyName) throws NoSuchFieldException {
        try {
            return startClass.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = startClass.getSuperclass();
            if (superclass != Object.class) {
                return this.getDeclaredFieldRecursive(superclass, propertyName);
            }
            throw new NoSuchFieldException("No field found for property " + propertyName);
        }
    }

    protected long getNextTestValue() {
        long value = this.nextValue++;
        return value;
    }

    protected Object createValue(Type type) {
        Type rawType;
        Class clazz = null;
        ParameterizedType parameterizedType = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            clazz = (Class)rawType;
        }
        if (clazz != null && clazz.isArray()) {
            Object array = Array.newInstance(clazz.getComponentType(), 5);
            for (int i = 0; i < 5; ++i) {
                Array.set(array, i, this.createValue(clazz.getComponentType()));
            }
            return array;
        }
        if (clazz != null && clazz.isEnum()) {
            try {
                Method valuesMethod = clazz.getMethod("values", new Class[0]);
                Object[] values = (Object[])valuesMethod.invoke(null, new Object[0]);
                int n = (Integer)this.createValue(Integer.TYPE);
                return values[n % values.length];
            }
            catch (Exception e) {
                LOG.debug("Error getting enum value", (Throwable)e);
            }
        } else {
            Serializable result;
            if (parameterizedType != null && parameterizedType.getRawType() == Map.class) {
                result = new HashMap();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 2) {
                    throw new IllegalStateException("Have map with actualTypeArguments.length != 2");
                }
                for (int i = 0; i < 5; ++i) {
                    result.put(this.createValue(actualTypeArguments[0]), this.createValue(actualTypeArguments[1]));
                }
                return Collections.unmodifiableMap(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == List.class) {
                result = new ArrayList();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableList(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == Set.class) {
                result = new HashSet();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableSet(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == Collection.class) {
                result = new HashSet();
                this.addValuesToCollection((Collection<Object>)((Object)result), parameterizedType);
                return Collections.unmodifiableCollection(result);
            }
            if (parameterizedType != null && parameterizedType.getRawType() == AtomicReference.class) {
                result = new AtomicReference();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments.length != 1) {
                    throw new IllegalStateException("Have parameterizedType with actualTypeArguments.length != 1");
                }
                ((AtomicReference)result).set(this.createValue(actualTypeArguments[0]));
                return result;
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.getNextTestValue();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return (int)this.getNextTestValue();
            }
            if (type == Character.TYPE || type == Character.class) {
                return Character.valueOf((char)this.getNextTestValue());
            }
            if (type == Short.TYPE || type == Short.class) {
                return (short)this.getNextTestValue();
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return (byte)this.getNextTestValue();
            }
            if (type == Float.TYPE || type == Float.class) {
                return Float.valueOf(this.getNextTestValue());
            }
            if (type == Double.TYPE || type == Double.class) {
                return (double)this.getNextTestValue();
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return this.getNextTestValue() % 2L == 0L;
            }
            if (type == String.class) {
                return Long.toHexString(this.getNextTestValue());
            }
            if (type == Date.class) {
                return new Date(System.currentTimeMillis() - this.getNextTestValue() * 100000L);
            }
            if (type == Object.class) {
                return this.createValue((Type)((Object)String.class));
            }
        }
        throw new UnsupportedOperationException("Test " + this.getClass() + " must override createValue(Type type) and return a value for type " + type);
    }

    private void addValuesToCollection(Collection<Object> result, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length != 1) {
            throw new IllegalStateException("Have collection with actualTypeArguments.length != 1");
        }
        for (int i = 0; i < 5; ++i) {
            result.add(this.createValue(actualTypeArguments[0]));
        }
    }

    protected Object fillProperty(T entity, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object value;
        try {
            value = this.createValue(this.getPropertyGenericType(propertyName));
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Could not create value for property '" + propertyName + "': " + e.getMessage(), e);
        }
        return this.fillProperty(entity, propertyName, value);
    }

    private Object fillProperty(T entity, String propertyName, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Method setter = this.getSetter(this.getPropertyType(propertyName), propertyName);
        if (setter != null) {
            setter.invoke(entity, value);
        } else {
            Field field = this.getDeclaredFieldRecursive(this.beanClass, propertyName);
            field.setAccessible(true);
            field.set(entity, value);
        }
        return value;
    }

    private Method getSetter(Class<?> propertyType, String propertyName) {
        String upperName = propertyName.length() == 1 ? propertyName.toUpperCase() : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String setterName = SETTER_PREFIX + upperName;
        try {
            return this.getMethod(this.beanClass, setterName, propertyType);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("No setter found for property: " + this.beanClass.getName() + CLASS_AND_FIELD_SEPERATOR + propertyName);
            return null;
        }
    }

    private Method getGetter(String propertyName) {
        String upperName = propertyName.length() == 1 ? propertyName.toUpperCase() : propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String getterName = "get" + upperName;
        try {
            return this.getMethod(this.beanClass, getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getterName = "is" + upperName;
            try {
                return this.getMethod(this.beanClass, getterName, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                LOG.warn("No getter found for property: " + this.beanClass.getName() + CLASS_AND_FIELD_SEPERATOR + propertyName);
                return null;
            }
        }
    }

    private Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return this.getMethod(superclass, name, parameterTypes);
            }
            throw new NoSuchMethodException(name);
        }
    }

    protected Object getFieldValue(T entity, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object fieldValue;
        Method getter = this.getGetter(propertyName);
        if (getter != null) {
            getter.setAccessible(true);
            fieldValue = getter.invoke(entity, new Object[0]);
        } else {
            Field field = this.getDeclaredField(propertyName);
            field.setAccessible(true);
            fieldValue = field.get(entity);
        }
        return fieldValue;
    }

    protected String[] getIgnorePropertyNames() {
        return null;
    }

    private boolean isIgnoreProperty(String propertyName) {
        String[] ignorePropertyNames = this.getIgnorePropertyNames();
        if (ignorePropertyNames == null) {
            return false;
        }
        for (String ignoreName : ignorePropertyNames) {
            if (ignoreName == null || !ignoreName.equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBeanFieldCandidate(Field field) {
        return (field.getModifiers() & 8) == 0 && (field.getModifiers() & 0x80) == 0 && !this.isIgnoreProperty(field.getName());
    }

    protected T createInstance(ConstructorParameters constructorParameters) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] propertyValues;
        Class<?>[] types = constructorParameters.getTypes();
        Constructor<T> constructor = this.beanClass.getDeclaredConstructor(types);
        constructor.setAccessible(true);
        if (this.allConstructorPropertyValues == null) {
            this.allConstructorPropertyValues = new HashMap<Class<?>[], Object[]>();
        }
        if ((propertyValues = this.allConstructorPropertyValues.get(types)) == null) {
            Type[] genericTypes = constructor.getGenericParameterTypes();
            assert (genericTypes.length == types.length);
            propertyValues = new Object[genericTypes.length];
            for (int i = 0; i < genericTypes.length; ++i) {
                propertyValues[i] = this.createValue(genericTypes[i]);
            }
            this.allConstructorPropertyValues.put(types, propertyValues);
        }
        return constructor.newInstance(propertyValues);
    }

    protected ConstructorParameters[] getConstructorParameters() {
        return new ConstructorParameters[]{DEFAULT_CONSTRUCTOR_PARAMETERS};
    }

    protected void assertEquals(String message, Object expected, Object actual) {
        if (expected != null && actual != null) {
            if (!(expected.getClass() != Double.TYPE && expected.getClass() != Double.class || actual.getClass() != Double.TYPE && actual.getClass() != Double.class)) {
                Assert.assertEquals((double)((Double)expected), (double)((Double)actual), (double)1.0E-13f);
                return;
            }
            if (!(expected.getClass() != Float.TYPE && expected.getClass() != Float.class || actual.getClass() != Float.TYPE && actual.getClass() != Float.class)) {
                Assert.assertEquals((float)((Float)expected).floatValue(), (float)((Float)actual).floatValue(), (float)1.0E-13f);
                return;
            }
            if (expected.getClass().isArray() && actual.getClass().isArray()) {
                if (expected.getClass().getComponentType() == Integer.TYPE && actual.getClass().getComponentType() == Integer.TYPE) {
                    Assert.assertArrayEquals((int[])((int[])expected), (int[])((int[])actual));
                    return;
                }
                if (expected.getClass().getComponentType() == Byte.TYPE && actual.getClass().getComponentType() == Byte.TYPE) {
                    Assert.assertArrayEquals((byte[])((byte[])expected), (byte[])((byte[])actual));
                    return;
                }
                if (expected.getClass().getComponentType() == Character.TYPE && actual.getClass().getComponentType() == Character.TYPE) {
                    Assert.assertArrayEquals((char[])((char[])expected), (char[])((char[])actual));
                    return;
                }
                if (expected.getClass().getComponentType() == Long.TYPE && actual.getClass().getComponentType() == Long.TYPE) {
                    Assert.assertArrayEquals((long[])((long[])expected), (long[])((long[])actual));
                    return;
                }
                if (expected.getClass().getComponentType() == Short.TYPE && actual.getClass().getComponentType() == Short.TYPE) {
                    Assert.assertArrayEquals((short[])((short[])expected), (short[])((short[])actual));
                    return;
                }
                if (expected.getClass().getComponentType() == Boolean.TYPE && actual.getClass().getComponentType() == Boolean.TYPE) {
                    new ExactComparisonCriteria().arrayEquals(message, expected, actual);
                    return;
                }
                if (expected.getClass().getComponentType() == Double.TYPE && actual.getClass().getComponentType() == Double.TYPE) {
                    Assert.assertArrayEquals((double[])((double[])expected), (double[])((double[])actual), (double)1.0E-13f);
                    return;
                }
                if (expected.getClass().getComponentType() == Float.TYPE && actual.getClass().getComponentType() == Float.TYPE) {
                    Assert.assertArrayEquals((float[])((float[])expected), (float[])((float[])actual), (float)1.0E-13f);
                    return;
                }
                try {
                    Assert.assertArrayEquals((Object[])((Object[])expected), (Object[])((Object[])actual));
                    return;
                }
                catch (ClassCastException classCastException) {}
            } else if (Collection.class.isAssignableFrom(expected.getClass()) && !List.class.isAssignableFrom(expected.getClass())) {
                this.assertEquals(message, (Collection)expected, (Collection)actual);
                return;
            }
        }
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    protected void assertEquals(String message, Collection<?> expected, Collection<?> actual) {
        if (expected == actual) {
            return;
        }
        if (expected == null) {
            Assert.assertNull((String)message, actual);
            return;
        }
        Assert.assertNotNull((String)message, actual);
        Assert.assertEquals((String)message, (long)expected.size(), (long)actual.size());
        Assert.assertTrue((String)message, (boolean)actual.containsAll(expected));
    }

    private Type getPropertyGenericType(String propertyName) {
        try {
            Field field = this.getDeclaredField(propertyName);
            return field.getGenericType();
        }
        catch (NoSuchFieldException e) {
            Method getter = this.getGetter(propertyName);
            if (getter == null) {
                throw new IllegalStateException(String.format("Property '%s' not found as field or getter", propertyName));
            }
            return getter.getGenericReturnType();
        }
    }

    private Class<?> getPropertyType(String propertyName) {
        try {
            Field field = this.getDeclaredField(propertyName);
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            Method getter = this.getGetter(propertyName);
            if (getter == null) {
                throw new IllegalStateException(String.format("Property '%s' not found as field org getter", propertyName));
            }
            return getter.getReturnType();
        }
    }

    private static Set<String> toSet(String[] s) {
        HashSet set = null;
        if (s != null && s.length > 0) {
            set = new HashSet(s.length);
            Collections.addAll(set, s);
        }
        return set;
    }

    protected Map<String, Object> fillBean(T bean, String[] propertiesToOmit) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Set<String> propsToOmit = BeanTestBase.toSet(propertiesToOmit);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Collection<String> beanPropertyNames = this.getBeanPropertyNames();
        for (String propertyName : beanPropertyNames) {
            if (propsToOmit != null && propsToOmit.contains(propertyName)) continue;
            Object value = this.fillProperty(bean, propertyName);
            result.put(propertyName, value);
        }
        return result;
    }

    private boolean declaresEquals() throws NoSuchMethodException {
        return this.beanClass.getMethod("equals", Object.class).getDeclaringClass() != Object.class;
    }

    private boolean declaresHashCode() throws NoSuchMethodException {
        return this.beanClass.getMethod("hashCode", new Class[0]).getDeclaringClass() != Object.class;
    }

    @Test
    public void propertyTestForAllConstructors() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        ConstructorParameters[] allConstructorParameters;
        for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
            LOG.info("Testing properties for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
            T bean = this.createInstance(constructorParameters);
            String[] constructorPropertyNames = constructorParameters.getPropertyNames();
            Map<String, Object> propertyValues = this.fillBean(bean, constructorPropertyNames);
            if (this.allConstructorPropertyValues != null) {
                Object[] constructorPropertyValues = this.allConstructorPropertyValues.get(constructorParameters.getTypes());
                for (int i = 0; i < constructorPropertyValues.length; ++i) {
                    Object expectedValue = constructorPropertyValues[i];
                    String propertyName = constructorPropertyNames[i];
                    if (this.isIgnoreProperty(propertyName)) continue;
                    Object actualValue = this.getFieldValue(bean, propertyName);
                    this.assertEquals("Constructor property value " + propertyName, expectedValue, actualValue);
                }
            }
            Set<String> propsToOmit = BeanTestBase.toSet(constructorPropertyNames);
            Collection<String> propertyNames = this.getBeanPropertyNames();
            for (String propertyName : propertyNames) {
                if (propsToOmit != null && propsToOmit.contains(propertyName)) continue;
                Object expectedValue = propertyValues.get(propertyName);
                Object actualValue = this.getFieldValue(bean, propertyName);
                this.assertEquals("Property value " + propertyName, expectedValue, actualValue);
            }
        }
    }

    @Test
    public void copyConstructorEqualsTest() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (this.declaresEquals()) {
            Constructor<T> copyConstructor = this.getCopyConstructor();
            if (copyConstructor != null) {
                ConstructorParameters[] allConstructorParameters;
                for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                    LOG.info("Testing equals (equality) for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                    String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                    T bean1 = this.createInstance(constructorParameters);
                    this.fillBean(bean1, constructorPropertyNames);
                    T bean2 = copyConstructor.newInstance(bean1);
                    Assert.assertEquals((String)"Bean created with copy constructor is not equal to original bean", bean1, bean2);
                }
            } else {
                LOG.info(String.format("Skipping copy constructor / equals (values) test as '%s' does not implement a copy constructor.", this.beanClass.getName()));
                RuntimeIgnore.ignore();
            }
        } else {
            LOG.info(String.format("Skipping copy constructor / equals (values) test as '%s' does not implement equals.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    @Test
    public void copyConstructorValuesTest() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Constructor<T> copyConstructor = this.getCopyConstructor();
        if (copyConstructor != null) {
            ConstructorParameters[] allConstructorParameters;
            for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                LOG.info("Testing properties for copy constructor vs. constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                T bean = this.createInstance(constructorParameters);
                String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                Map<String, Object> propertyValues = this.fillBean(bean, constructorPropertyNames);
                T copiedBean = copyConstructor.newInstance(bean);
                if (this.allConstructorPropertyValues != null) {
                    Object[] constructorPropertyValues = this.allConstructorPropertyValues.get(constructorParameters.getTypes());
                    for (int i = 0; i < constructorPropertyValues.length; ++i) {
                        Object expectedValue = constructorPropertyValues[i];
                        String propertyName = constructorPropertyNames[i];
                        if (this.isIgnoreProperty(propertyName)) continue;
                        Object actualValue = this.getFieldValue(copiedBean, propertyName);
                        this.assertEquals("Constructor property value " + propertyName, expectedValue, actualValue);
                    }
                }
                Set<String> propsToOmit = BeanTestBase.toSet(constructorPropertyNames);
                Collection<String> propertyNames = this.getBeanPropertyNames();
                for (String propertyName : propertyNames) {
                    if (propsToOmit != null && propsToOmit.contains(propertyName)) continue;
                    Object expectedValue = propertyValues.get(propertyName);
                    Object actualValue = this.getFieldValue(copiedBean, propertyName);
                    this.assertEquals("Property value " + propertyName, expectedValue, actualValue);
                }
            }
        } else {
            LOG.info(String.format("Skipping copy constructor test as '%s' does not implement a copy constructor.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    @Test
    public void copyConstructorEmptyEqualsTest() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (this.declaresEquals()) {
            Constructor<T> copyConstructor = this.getCopyConstructor();
            if (copyConstructor != null) {
                ConstructorParameters[] allConstructorParameters;
                for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                    LOG.info("Testing equals (equality) for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                    T bean1 = this.createInstance(constructorParameters);
                    T bean2 = copyConstructor.newInstance(bean1);
                    Assert.assertEquals((String)"Bean created with copy constructor is not equal to original bean", bean1, bean2);
                }
            } else {
                LOG.info(String.format("Skipping copy constructor / equals (values) test as '%s' does not implement a copy constructor.", this.beanClass.getName()));
                RuntimeIgnore.ignore();
            }
        } else {
            LOG.info(String.format("Skipping copy constructor / equals (values) test as '%s' does not implement equals.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    @Test
    public void copyConstructorEmptyValuesTest() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Constructor<T> copyConstructor = this.getCopyConstructor();
        if (copyConstructor != null) {
            ConstructorParameters[] allConstructorParameters;
            for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                LOG.info("Testing properties for copy constructor vs. constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                T bean = this.createInstance(constructorParameters);
                String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                T copiedBean = copyConstructor.newInstance(bean);
                Set<String> propsToOmit = BeanTestBase.toSet(constructorPropertyNames);
                Collection<String> propertyNames = this.getBeanPropertyNames();
                for (String propertyName : propertyNames) {
                    if (propsToOmit != null && propsToOmit.contains(propertyName)) continue;
                    Object expectedValue = this.getFieldDefaultValue(propertyName);
                    Object actualValue = this.getFieldValue(copiedBean, propertyName);
                    this.assertEquals("Property value " + propertyName, expectedValue, actualValue);
                }
            }
        } else {
            LOG.info(String.format("Skipping copy constructor test as '%s' does not implement a copy constructor.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    private Constructor<T> getCopyConstructor() {
        try {
            return this.beanClass.getConstructor(this.beanClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Object getFieldDefaultValue(String propertyName) {
        Class<?> type = this.getPropertyType(propertyName);
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    @Test
    public void toStringTestForAllConstructorsEmpty() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        ConstructorParameters[] allConstructorParameters;
        for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
            LOG.info("Testing properties for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
            T bean = this.createInstance(constructorParameters);
            Assert.assertNotNull((Object)bean.toString());
        }
    }

    @Test
    public void toStringTestForAllConstructorsFilled() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        ConstructorParameters[] allConstructorParameters;
        for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
            LOG.info("Testing properties for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
            T bean = this.createInstance(constructorParameters);
            String[] constructorPropertyNames = constructorParameters.getPropertyNames();
            this.fillBean(bean, constructorPropertyNames);
            Assert.assertNotNull((Object)bean.toString());
        }
    }

    @Test
    public void equalsIdentityTest() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        if (this.declaresEquals()) {
            ConstructorParameters[] allConstructorParameters;
            for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                LOG.info("Testing equals (identity) for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                T bean = this.createInstance(constructorParameters);
                String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                this.fillBean(bean, constructorPropertyNames);
                Assert.assertEquals((String)"Same beans are not equal", bean, bean);
            }
        } else {
            LOG.info(String.format("Skipping equals (identity) test as '%s' does not implement equals.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    @Test
    public void equalsValuesTest() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        if (this.declaresEquals()) {
            ConstructorParameters[] allConstructorParameters;
            for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                LOG.info("Testing equals (equality) for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                T bean1 = this.createInstance(constructorParameters);
                Map<String, Object> values = this.fillBean(bean1, constructorPropertyNames);
                T bean2 = this.createInstance(constructorParameters);
                for (Map.Entry<String, Object> e : values.entrySet()) {
                    this.fillProperty(bean2, e.getKey(), e.getValue());
                }
                Assert.assertEquals((String)"Beans with same property values are not equal", bean1, bean2);
            }
        } else {
            LOG.info(String.format("Skipping equals (values) test as '%s' does not implement equals.", this.beanClass.getName()));
            RuntimeIgnore.ignore();
        }
    }

    @Test
    public void hashCodeTest() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        if (this.declaresHashCode()) {
            ConstructorParameters[] allConstructorParameters;
            for (ConstructorParameters constructorParameters : allConstructorParameters = this.getConstructorParameters()) {
                LOG.info("Testing hashCode for constructor with parameter types " + Arrays.toString(constructorParameters.getTypes()));
                String[] constructorPropertyNames = constructorParameters.getPropertyNames();
                T bean1 = this.createInstance(constructorParameters);
                Map<String, Object> values = this.fillBean(bean1, constructorPropertyNames);
                T bean2 = this.createInstance(constructorParameters);
                for (Map.Entry<String, Object> e : values.entrySet()) {
                    this.fillProperty(bean2, e.getKey(), e.getValue());
                }
                Assert.assertEquals((String)"Beans with same property values do not have same hashCode", (long)bean1.hashCode(), (long)bean2.hashCode());
            }
        } else {
            LOG.info("Skipping hashCode test as " + this.beanClass + " does not implement hashCode.");
            RuntimeIgnore.ignore();
        }
    }

    protected static class ConstructorParameters {
        private final Class<?>[] types;
        private final String[] propertyNames;

        public ConstructorParameters(Class<?>[] types, String[] propertyNames) {
            if (types == null || propertyNames == null || types.length != propertyNames.length) {
                throw new IllegalArgumentException();
            }
            this.types = types;
            this.propertyNames = propertyNames;
        }

        public Class<?>[] getTypes() {
            return this.types;
        }

        public String[] getPropertyNames() {
            return this.propertyNames;
        }
    }
}

