/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.junitsupport;

import de.mklinger.commons.junitsupport.TestValueFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Not a test")
public class DelegateClassTestBase
extends TestValueFactory {
    private final Class<?> delegateType;
    private final Class<?> classUnderTest;
    private final TestMethod[] testMethods;

    public DelegateClassTestBase(Class<?> delegateType, Class<?> classUnderTest, TestMethod ... testMethods) {
        this.delegateType = delegateType;
        this.classUnderTest = classUnderTest;
        this.testMethods = testMethods.length == 0 ? DelegateClassTestBase.declaredTestMethodsFor(delegateType) : testMethods;
    }

    public static TestMethod[] declaredTestMethodsFor(Class<?> type) {
        Method[] methods = type.getDeclaredMethods();
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>(methods.length);
        for (Method method : methods) {
            if (!DelegateClassTestBase.isTestMethodCandidate(method)) continue;
            testMethods.add(new TestMethod(method.getName(), method.getReturnType(), method.getParameterTypes(), null));
        }
        return testMethods.toArray(new TestMethod[0]);
    }

    private static boolean isTestMethodCandidate(Method method) {
        int modifiers = method.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isPrivate(modifiers) && !"$jacocoInit".equals(method.getName());
    }

    private void testDelegateMethod(TestMethod testMethod) throws Exception {
        boolean haveReturn = testMethod.returnType != null && testMethod.returnType != Void.TYPE;
        Object returnValue = null;
        if (haveReturn) {
            returnValue = this.createValue(testMethod.returnType);
        }
        Object delegate = EasyMock.createStrictMock(this.delegateType);
        Method method = delegate.getClass().getMethod(testMethod.name, testMethod.parameterTypes);
        Object[] actualParameters = this.getParameters(testMethod);
        method.invoke(delegate, actualParameters);
        if (haveReturn) {
            EasyMock.expectLastCall().andReturn(returnValue);
        } else {
            EasyMock.expectLastCall().andVoid();
        }
        EasyMock.replay((Object[])new Object[]{delegate});
        Object instanceUnderTest = this.createInstanceUnderTest(delegate);
        Method delegateMethod = instanceUnderTest.getClass().getMethod(testMethod.name, testMethod.parameterTypes);
        Object actualReturnValue = delegateMethod.invoke(instanceUnderTest, actualParameters);
        if (haveReturn) {
            Assert.assertEquals((Object)returnValue, (Object)actualReturnValue);
        }
        EasyMock.verify((Object[])new Object[]{delegate});
    }

    private Object[] getParameters(TestMethod testMethod) {
        if (testMethod.parameters != null) {
            return testMethod.parameters;
        }
        Object[] parameters = new Object[testMethod.parameterTypes.length];
        for (int i = 0; i < testMethod.parameterTypes.length; ++i) {
            parameters[i] = this.createValue(testMethod.parameterTypes[i]);
        }
        return parameters;
    }

    private Object createInstanceUnderTest(Object delegate) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = this.classUnderTest.getConstructor(this.delegateType);
        Object instanceUnderTest = constructor.newInstance(delegate);
        return instanceUnderTest;
    }

    @Test
    public void testDelegateMethods() throws Exception {
        for (TestMethod testMethod : this.testMethods) {
            try {
                this.testDelegateMethod(testMethod);
            }
            catch (Exception e) {
                String msg = "Error testing delegate method " + testMethod.name + "(" + Arrays.toString(testMethod.parameterTypes) + "): " + e.toString();
                throw new AssertionError(msg, e);
            }
        }
    }

    public static class TestMethod {
        private final String name;
        private final Class<?> returnType;
        private final Class<?>[] parameterTypes;
        private final Object[] parameters;

        public TestMethod(String name, Class<?> returnType, Class<?>[] parameterTypes, Object[] parameters) {
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.parameters = parameters;
        }

        public TestMethod(String name, Class<?>[] parameterTypes, Object[] parameters) {
            this(name, null, parameterTypes, parameters);
        }
    }
}

