/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec;

import de.mklinger.commons.exec.Cmd;
import de.mklinger.commons.exec.CmdSettings;
import de.mklinger.commons.exec.Pingable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class CmdBuilderBase<B extends CmdBuilderBase<B>> {
    private final CmdSettings cmdSettings = new CmdSettings();
    private boolean inheritEnvironment = true;
    private Set<String> withoutEnvironment = null;

    public B stdout(OutputStream stdout) {
        this.cmdSettings.setStdout(stdout);
        return this.getBuilder();
    }

    public B stdout(File stdout) {
        this.cmdSettings.setStdoutFile(stdout);
        return this.getBuilder();
    }

    public B stdout(Path stdout) {
        return this.stdout(stdout.toFile());
    }

    public B stderr(OutputStream stderr) {
        this.cmdSettings.setStderr(stderr);
        return this.getBuilder();
    }

    public B stderr(File stderr) {
        this.cmdSettings.setStderrFile(stderr);
        return this.getBuilder();
    }

    public B stderr(Path stderr) {
        return this.stderr(stderr.toFile());
    }

    public B redirectErrorStream(boolean redirectErrorStream) {
        this.cmdSettings.setRedirectErrorStream(redirectErrorStream);
        return this.getBuilder();
    }

    public B stdin(byte[] stdinBytes) {
        this.cmdSettings.setStdinBytes(stdinBytes);
        return this.getBuilder();
    }

    public B ping(Pingable pingable) {
        this.cmdSettings.setPingable(pingable);
        return this.getBuilder();
    }

    public B directory(File directory) {
        this.cmdSettings.setDirectory(directory);
        return this.getBuilder();
    }

    public B directory(Path directory) {
        return this.directory(directory.toFile());
    }

    public B inheritEnvironment(boolean inheritEnvironment) {
        this.inheritEnvironment = inheritEnvironment;
        return this.getBuilder();
    }

    public B environment(String name, String value) {
        if (this.cmdSettings.getEnvironment() == null) {
            this.cmdSettings.setEnvironment(new HashMap<String, String>());
        }
        this.cmdSettings.getEnvironment().put(name, value);
        return this.getBuilder();
    }

    public B withoutEnvironment(String name) {
        if (this.withoutEnvironment == null) {
            this.withoutEnvironment = new HashSet<String>();
        }
        this.withoutEnvironment.add(name);
        return this.getBuilder();
    }

    public B timeout(long timeout) {
        this.cmdSettings.setTimeout(timeout);
        return this.getBuilder();
    }

    public B timeout(int duration, TimeUnit timeUnit) {
        return this.timeout(timeUnit.toMillis(duration));
    }

    public B destroyOnError(boolean destroyOnError) {
        this.cmdSettings.setDestroyOnError(destroyOnError);
        return this.getBuilder();
    }

    public B destroyOnShutdown(boolean destroyOnShutdown) {
        this.cmdSettings.setDestroyOnShutdown(destroyOnShutdown);
        return this.getBuilder();
    }

    public B destroyForcibly(boolean destroyForcibly) {
        this.cmdSettings.setDestroyForcibly(destroyForcibly);
        return this.getBuilder();
    }

    public B args(Object ... arguments) {
        if (this.cmdSettings.getCommand() == null) {
            this.cmdSettings.setCommand(new ArrayList<String>());
        }
        this.addArguments(this.cmdSettings.getCommand(), arguments);
        return this.getBuilder();
    }

    public B arg(Object argument) {
        if (this.cmdSettings.getCommand() == null) {
            this.cmdSettings.setCommand(new ArrayList<String>());
        }
        this.addArguments(this.cmdSettings.getCommand(), argument);
        return this.getBuilder();
    }

    private void addArguments(List<String> command, Object ... arguments) {
        if (arguments == null) {
            return;
        }
        for (Object o : arguments) {
            if (o == null) continue;
            if (o.getClass().isArray()) {
                this.addArguments(command, (Object[])o);
                continue;
            }
            if (Collection.class.isAssignableFrom(o.getClass())) {
                Collection c = (Collection)o;
                Object[] array = new Object[c.size()];
                int idx = 0;
                for (Object object : c) {
                    array[idx] = object;
                    ++idx;
                }
                this.addArguments(command, array);
                continue;
            }
            if (File.class.isAssignableFrom(o.getClass())) {
                command.add(((File)o).getAbsolutePath());
                continue;
            }
            command.add(String.valueOf(o));
        }
    }

    public B executorSupplier(Supplier<Executor> executorSupplier) {
        this.cmdSettings.setExecutorSupplier(executorSupplier);
        return this.getBuilder();
    }

    public CmdSettings toCmdSettings() {
        CmdSettings cmdSettings = new CmdSettings(this.cmdSettings);
        HashMap<String, String> env = null;
        Map<String, String> settingsEnv = cmdSettings.getEnvironment();
        if (this.inheritEnvironment && settingsEnv != null) {
            env = new HashMap<String, String>(System.getenv());
            env.putAll(settingsEnv);
        }
        if (this.withoutEnvironment != null) {
            if (env == null) {
                env = settingsEnv != null ? new HashMap<String, String>(settingsEnv) : new HashMap();
            }
            for (String name : this.withoutEnvironment) {
                env.remove(name);
            }
        }
        if (env != null) {
            cmdSettings.setEnvironment(env);
        }
        return cmdSettings;
    }

    public Cmd toCmd() {
        CmdSettings clone = this.toCmdSettings();
        clone.freeze();
        return new Cmd(clone);
    }

    protected B getBuilder() {
        return (B)this;
    }
}

