/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.commons.exec.docker;

import java.nio.file.Paths;
import java.util.Locale;

public class Volume {
    private static final String WINDOWS_PREFIX = "c:\\users\\";
    private final String hostPathOrVolume;
    private final String containerPath;
    private final String options;

    public Volume(String hostPathOrVolume, String containerPath) {
        this(hostPathOrVolume, containerPath, null);
    }

    public Volume(String hostPathOrVolume, String containerPath, String options) {
        this.hostPathOrVolume = hostPathOrVolume;
        this.containerPath = containerPath;
        this.options = options;
    }

    public String toArgString(boolean forDockerMachine) {
        String actualHostPathOrVolume;
        if (forDockerMachine && Paths.get(this.hostPathOrVolume, new String[0]).isAbsolute()) {
            if (!this.hostPathOrVolume.toLowerCase(Locale.US).startsWith(WINDOWS_PREFIX)) {
                throw new IllegalArgumentException("For docker-machine, only host paths under C:\\Users\\ can be mounted");
            }
            actualHostPathOrVolume = "/c/Users/" + this.hostPathOrVolume.substring(WINDOWS_PREFIX.length()).replace('\\', '/');
        } else {
            actualHostPathOrVolume = this.hostPathOrVolume;
        }
        if (this.options != null) {
            return actualHostPathOrVolume + ":" + this.containerPath + ":" + this.options;
        }
        return actualHostPathOrVolume + ":" + this.containerPath;
    }
}

